/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class HttpRequest {
    private final Map<String, String> parameterMap;
    private String rawRequest;
    private String urlRequest;
    private final Map<String, String> httpHeader;
    private String httpProtocol;
    private final InputStream inputStream;
    private HttpMethod httpMethod;
    private final InetAddress remoteAddress;
    private final int remotePort;
    private final Socket socket;

    protected HttpRequest(Socket socket) throws Exception {
        this.socket = socket;
        this.parameterMap = new HashMap<String, String>();
        this.rawRequest = "";
        this.urlRequest = "";
        this.httpHeader = new HashMap<String, String>();
        this.httpMethod = HttpMethod.INVALID;
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.remoteAddress = socket.getInetAddress();
        this.remotePort = socket.getPort();
        this.initialize();
    }

    private void initialize() throws Exception {
        InputStream inputStream = this.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int value = -1;
        int lastChar = 0;
        char currChar = '\u0000';
        while ((value = inputStream.read()) != -1) {
            currChar = (char)value;
            if (currChar != '\n' && currChar != '\r') {
                buffer.write((byte)value);
            }
            if (lastChar == 13 && currChar == '\n') {
                String toProcess = buffer.toString("ISO-8859-1");
                buffer.reset();
                if (!Strings.isValid((String)toProcess)) break;
                if (toProcess.contains("HTTP")) {
                    this.parseRequest(toProcess);
                } else {
                    this.parseHeader(toProcess);
                }
            }
            lastChar = currChar;
        }
    }

    private void parseHeader(String line) throws Exception {
        Matcher matcher = Pattern.compile("(.*?):\\s*(.*)").matcher(line);
        if (matcher.matches()) {
            this.httpHeader.put(matcher.group(1), matcher.group(2));
        }
    }

    public String getParameter(String key) {
        String toReturn = this.parameterMap.get(key);
        return Strings.isValid((String)toReturn) ? toReturn : "";
    }

    public Set<String> getParameterKeys() {
        return this.parameterMap.keySet();
    }

    public String getParametersAsString() {
        return this.parameterMap.toString();
    }

    public Map<String, String> getParameters() {
        return this.parameterMap;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public InetAddress getOriginatingAddress() {
        return this.remoteAddress;
    }

    public int getOriginatingPort() {
        return this.remotePort;
    }

    public String getHttpHeaderEntry(String key) {
        String toReturn = this.httpHeader.get(key);
        return Strings.isValid((String)toReturn) ? toReturn : "";
    }

    public Set<String> getHttpHeaderKeys() {
        return this.httpHeader.keySet();
    }

    public String getHttpProtocol() {
        return this.httpProtocol;
    }

    public String getUrlRequest() {
        return this.urlRequest;
    }

    public String getRawRequest() {
        return this.rawRequest;
    }

    public Socket getSocket() {
        return this.socket;
    }

    private void parseRequest(String entry) throws Exception {
        this.rawRequest = entry;
        OseeLog.log(Activator.class, (Level)Level.INFO, (String)("HttpRequest *" + this.rawRequest + "*"));
        String[] entries = this.rawRequest.split("\\s");
        if (entries.length > 0 && entries.length < 4) {
            this.httpMethod = HttpMethod.valueOf(entries[0].trim());
            this.httpProtocol = entries[2].trim();
            String request = entries[1].trim();
            boolean wasOldStyle = this.parseOldSchoolStyleLinks(request);
            if (!wasOldStyle) {
                this.parseNewStyleRequests(request);
            }
        }
    }

    private void parseNewStyleRequests(String request) throws Exception {
        String noHostStr = request.replaceFirst("^http:\\/\\/(.*?)\\/", "/");
        Matcher matcher = Pattern.compile("/(.*?)\\?(.*)").matcher(noHostStr);
        if (matcher.matches()) {
            this.urlRequest = matcher.group(1);
            if (!Strings.isValid((String)this.urlRequest)) {
                throw new OseeArgumentException("Unknown requestType [%s]", new Object[]{this.rawRequest});
            }
            String data = matcher.group(2);
            Matcher dataMatcher = Pattern.compile("([^&]*?)=([^&]*)").matcher(data);
            while (dataMatcher.find()) {
                this.parameterMap.put(dataMatcher.group(1), URLDecoder.decode(dataMatcher.group(2), "UTF-8"));
            }
        } else {
            if (this.httpMethod.equals((Object)HttpMethod.GET)) {
                this.httpMethod = HttpMethod.RESOURCE_GET;
            }
            this.urlRequest = request;
        }
    }

    private boolean parseOldSchoolStyleLinks(String entry) throws Exception {
        boolean handled = false;
        Matcher oldMatcher = Pattern.compile("/(.*?)/guid/(.*?)/(.*)").matcher(entry);
        if (oldMatcher.find()) {
            handled = true;
            String guid = oldMatcher.group(2);
            if (oldMatcher.groupCount() > 2) {
                String processType = oldMatcher.group(3);
                if (processType.equals("ats")) {
                    this.parameterMap.put("guid", guid);
                    this.urlRequest = processType.toUpperCase();
                } else if (processType.equals("Define") || processType.equals("")) {
                    this.parameterMap.put("guid", guid);
                    this.urlRequest = "Define";
                } else {
                    throw new OseeArgumentException("Unnable to parse old style link [%s]", new Object[]{this.rawRequest});
                }
            }
        }
        return handled;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        RESOURCE_GET,
        INVALID;

    }
}

