/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.data.model.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CommandGroup;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.data.model.editor.GraphitiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.MenuCmdDef;
import org.eclipse.osee.framework.ui.skynet.render.DefaultArtifactRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class GraphitiRenderer
extends DefaultArtifactRenderer {
    public GraphitiRenderer(Map<RendererOption, Object> rendererOptions) {
        super(rendererOptions);
    }

    public GraphitiRenderer() {
        this(new HashMap<RendererOption, Object>());
    }

    public GraphitiRenderer newInstance(Map<RendererOption, Object> rendererOptions) {
        return new GraphitiRenderer(rendererOptions);
    }

    public GraphitiRenderer newInstance() {
        return new GraphitiRenderer();
    }

    public String getName() {
        return "GraphitiRenderer";
    }

    public int getApplicabilityRating(PresentationType presentationType, Artifact artifact, Map<RendererOption, Object> rendererOptions) {
        int rating = -1;
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.ModelDiagram}) && presentationType.matches(new PresentationType[]{PresentationType.RENDER_AS_HUMAN_READABLE_TEXT, PresentationType.PREVIEW, PresentationType.DEFAULT_OPEN, PresentationType.SPECIALIZED_EDIT})) {
            rating = 50;
        }
        return rating;
    }

    public void addMenuCommandDefinitions(ArrayList<MenuCmdDef> commands, Artifact artifact) {
        commands.add(new MenuCmdDef(CommandGroup.EDIT, PresentationType.SPECIALIZED_EDIT, "Diagram Editor", (KeyedImage)GraphitiImage.GRAPHITI_DIAGRAM));
    }

    public void open(final List<Artifact> artifacts, PresentationType presentationType) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = AWorkbench.getActivePage();
                    for (Artifact artifact : artifacts) {
                        AttributeId attributeId = (AttributeId)artifact.getAttributeIds((AttributeTypeId)CoreAttributeTypes.GraphitiDiagram).get(0);
                        URI diagramUri = URI.createURI((String)String.format("osee://branch/%s/artifact/%s/attribute/%s", artifact.getBranch().getIdString(), artifact.getIdString(), attributeId.getIdString()));
                        DiagramEditorInput editorInput = new DiagramEditorInput(diagramUri, null);
                        activePage.openEditor((IEditorInput)editorInput, "org.eclipse.osee.framework.ui.data.model.editor.graphiti.GraphitiDiagramArtifactEditor", true);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(GraphitiRenderer.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }
}

