/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.transition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelperAdapter;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.widgets.dialog.CancelledReasonEnumDialog;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionResultsUi;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionToOperation;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class TransitionToMenu {
    public static MenuManager createTransitionToMenuManager(XViewer xViewer, String name, Set<Artifact> workflowArtifacts) {
        MenuManager editMenuManager = new MenuManager(name, ImageManager.getImageDescriptor((OseeImage)AtsImage.TRANSITION), "transition-to");
        final HashSet<AbstractWorkflowArtifact> workItems = new HashSet<AbstractWorkflowArtifact>();
        ArrayList<IAtsStateDefinition> toStateDefs = new ArrayList<IAtsStateDefinition>();
        String workDefinitionId = null;
        HashMap<String, IAtsStateDefinition> stateNameToStateDef = new HashMap<String, IAtsStateDefinition>();
        boolean multipleWorkDefinitions = false;
        for (Artifact art : workflowArtifacts) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)art;
            workItems.add(awa);
            if (!multipleWorkDefinitions) {
                if (workDefinitionId == null) {
                    workDefinitionId = awa.getWorkDefinition().getName();
                } else if (!workDefinitionId.equals(awa.getWorkDefinition().getName())) {
                    multipleWorkDefinitions = true;
                }
            }
            try {
                for (IAtsStateDefinition stateDef : AtsApiService.get().getWorkItemService().getAllToStates((IAtsWorkItem)awa)) {
                    toStateDefs.add(stateDef);
                    stateNameToStateDef.put(stateDef.getName(), stateDef);
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        if (toStateDefs.isEmpty()) {
            editMenuManager.add((IAction)new Action("No Transitionable Selections", ImageManager.getImageDescriptor((OseeImage)AtsImage.TRANSITION)){

                public void run() {
                    AWorkbench.popup((String)"Error", (String)"No selection is in a transitionable state or transitionable together.");
                }
            });
        } else {
            ArrayList<String> toStateNames = new ArrayList<String>();
            for (IAtsStateDefinition stateDef : toStateDefs) {
                if (toStateNames.contains(stateDef.getName())) continue;
                toStateNames.add(stateDef.getName());
            }
            if (multipleWorkDefinitions) {
                Collections.sort(toStateNames);
            }
            for (final String stateName : toStateNames) {
                editMenuManager.add((IAction)new Action(TransitionToMenu.getTransitionToString(stateName, multipleWorkDefinitions, stateNameToStateDef), ImageManager.getImageDescriptor((OseeImage)AtsImage.TRANSITION)){

                    public void run() {
                        TransitionToMenu.handleTransitionToSelected(stateName, workItems);
                    }
                });
            }
        }
        return editMenuManager;
    }

    private static String getTransitionToString(String stateDefName, boolean multipleWorkDefinitions, Map<String, IAtsStateDefinition> stateNameToStateDef) {
        if (multipleWorkDefinitions) {
            return stateDefName;
        }
        IAtsStateDefinition stateDef = stateNameToStateDef.get(stateDefName);
        return String.format("%s%s%s", stateDef.getName(), TransitionToMenu.getStateTypeName(stateDef), TransitionToMenu.getDefaultStatePercent(stateDef));
    }

    private static Object getDefaultStatePercent(IAtsStateDefinition stateDef) {
        if (stateDef.getRecommendedPercentComplete() != null && stateDef.getRecommendedPercentComplete() != 0) {
            return String.format(" - %d%%", stateDef.getRecommendedPercentComplete());
        }
        return "";
    }

    private static String getStateTypeName(IAtsStateDefinition stateDef) {
        return stateDef.getStateType().isWorkingState() || stateDef.getName().equals(TeamState.Completed.getName()) || stateDef.getName().equals(TeamState.Cancelled.getName()) ? "" : " (" + stateDef.getStateType().name() + ")";
    }

    private static void handleTransitionToSelected(final String toStateName, final Set<IAtsWorkItem> workItems) {
        TransitionHelperAdapter helper = new TransitionHelperAdapter(AtsApiService.get()){

            public String getToStateName() {
                return toStateName;
            }

            public Collection<AtsUser> getToAssignees(IAtsWorkItem workItem) {
                return workItem.getAssignees();
            }

            public String getName() {
                return "Transition-To " + this.getToStateName();
            }

            public TransitionData getCancellationReason(final TransitionData transitionData) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IAtsWorkItem workItem = this.getWorkItems().iterator().next();
                        IAtsStateDefinition stateDef = null;
                        try {
                            stateDef = AtsApiService.get().getWorkDefinitionService().getStateDefinitionByName(workItem, this.getToStateName());
                        }
                        catch (OseeCoreException ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                        if (stateDef != null && stateDef.getStateType().isCancelledState()) {
                            boolean useEntryCancelWidgetDialog = false;
                            for (LayoutItem layoutItem : stateDef.getLayoutItems()) {
                                if (!layoutItem.getName().contains("Cancel")) continue;
                                useEntryCancelWidgetDialog = true;
                                break;
                            }
                            CancelledReasonEnumDialog cancelDialog = useEntryCancelWidgetDialog ? new CancelledReasonEnumDialog("Cancellation Reason", "Select cancellation reason.  If other, please specify with details in the text entry.") : new EntryDialog("Cancellation Reason", "Enter cancellation reason.");
                            if (cancelDialog.open() != 0) {
                                transitionData.setDialogCancelled(true);
                            }
                            if (useEntryCancelWidgetDialog) {
                                transitionData.setCancellationReason(cancelDialog.getEntry());
                                transitionData.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReasonEnum);
                                transitionData.setCancellationReasonDetails(cancelDialog.getCancelledDetails());
                            } else {
                                transitionData.setCancellationReason(cancelDialog.getEntry());
                                transitionData.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReason);
                            }
                        }
                    }
                }, (boolean)true);
                return transitionData;
            }

            public Collection<IAtsWorkItem> getWorkItems() {
                return workItems;
            }

            public IAtsChangeSet getChangeSet() {
                return null;
            }

            public Collection<IAtsTransitionHook> getTransitionListeners() {
                try {
                    HashSet listeners = new HashSet();
                    listeners.addAll(AtsApiService.get().getWorkItemService().getTransitionHooks());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                return Collections.emptyList();
            }

            public AtsApi getServices() {
                return AtsApiService.get();
            }

            public String getCancellationReasonDetails() {
                return null;
            }

            public String getCancellationReason() {
                return null;
            }
        };
        final TransitionToOperation operation = new TransitionToOperation((ITransitionHelper)helper);
        Operations.executeAsJob((IOperation)operation, (boolean)true, (int)20, (IJobChangeListener)new JobChangeAdapter((ITransitionHelper)helper){
            private final /* synthetic */ ITransitionHelper val$helper;
            {
                this.val$helper = iTransitionHelper;
            }

            public void done(IJobChangeEvent event) {
                TransitionResults results = operation.getResults();
                if (results.isErrors()) {
                    AtsUtilClient.logExceptions(results);
                    if (this.val$helper.getWorkItems().size() == 1) {
                        String resultStr = results.getResultString();
                        AWorkbench.popup((AWorkbench.MessageType)AWorkbench.MessageType.Error, (String)"Transition Failed", (String)resultStr);
                    } else {
                        TransitionResultsUi.reportDialog("Transition Failed", results);
                    }
                }
            }
        });
    }
}

