/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.widgets;

import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.widgets.CreateTasksFromSimpleList;
import org.eclipse.osee.ats.ide.workflow.task.widgets.XCheckBoxesWithTaskGenData;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.BlamEditor;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBoxData;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBoxes;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class XCheckBoxesWithTaskGen
extends XCheckBoxes
implements ArtifactWidget {
    private IAtsTeamWorkflow teamWf;
    private final AtsWorkDefinitionToken taskWorkDef;
    private final AtsApi atsApi;
    private List<XCheckBoxesWithTaskGenData> checkBoxesWithTasks;

    public XCheckBoxesWithTaskGen(String displayLabel, AtsWorkDefinitionToken taskWorkDef, int numColumns) {
        super(displayLabel, numColumns);
        this.taskWorkDef = taskWorkDef;
        this.atsApi = AtsApiService.get();
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        Composite buttonComp = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout(3, true);
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData());
        Button updateButton = new Button(buttonComp, 8);
        updateButton.setText("Generate Tasks from Checked");
        updateButton.setToolTipText("Generate tasks for any checked items that do not already have tasks.");
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XCheckBoxesWithTaskGen.this.handleTaskGen();
            }
        });
        Button addTasksButton = new Button(buttonComp, 8);
        addTasksButton.setText("Add Manual Task(s)");
        addTasksButton.setToolTipText("Create manual tasks using same naming and task workflow definition.");
        addTasksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XCheckBoxesWithTaskGen.this.handleManualTask();
            }
        });
        this.refreshEnablement();
    }

    private void refreshEnablement() {
        block0: for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
            for (XCheckBoxesWithTaskGenData cbTaskData : this.getLoadedCheckboxeWithTaskGenData()) {
                if (!task.getTags().contains(cbTaskData.getId().toString())) continue;
                cbTaskData.setTask(task);
                cbTaskData.getCheckBox().getCheckButton().setEnabled(false);
                cbTaskData.getCheckBox().getCheckButton().setSelection(false);
                String boxLabel = this.getTaskLabel(cbTaskData);
                cbTaskData.getCheckBox().setLabel(boxLabel);
                continue block0;
            }
        }
    }

    protected String getTaskLabel(XCheckBoxData cbd) {
        XCheckBoxesWithTaskGenData cbdTask = (XCheckBoxesWithTaskGenData)cbd;
        String name = cbd.getLabel();
        IAtsTask task = cbdTask.getTask();
        String state = "(No Task)";
        if (task != null) {
            state = " (" + task.getStateMgr().getCurrentStateName() + ")";
        }
        name = String.format("%s %s", name, state);
        return name;
    }

    protected void handleTaskGen() {
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getLabel(), (String)(String.valueOf(this.getLabel()) + "\n\nAre you sure?"))) {
            return;
        }
        NewTaskSet newTaskSet = NewTaskSet.create((String)this.getLabel(), (String)this.atsApi.getUserService().getCurrentUserId());
        NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)this.teamWf);
        newTaskData.setTaskWorkDef(this.taskWorkDef);
        for (XCheckBoxesWithTaskGenData cbTaskData : this.getLoadedCheckboxeWithTaskGenData()) {
            if (!cbTaskData.isChecked() || cbTaskData.getTask() != null) continue;
            JaxAtsTask task = new JaxAtsTask();
            String name = String.format(this.getTaskNameFormat(), cbTaskData.getLabel());
            task.setName(name);
            task.addAttribute((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)cbTaskData.getId());
            task.setCreatedByUserId(this.atsApi.getUserService().getCurrentUserId());
            task.setCreatedDate(new Date());
            newTaskData.add(task);
        }
        if (newTaskData.getTasks().isEmpty()) {
            AWorkbench.popup((String)"No New Tasks To Create");
        } else {
            newTaskSet = this.atsApi.getTaskService().createTasks(newTaskSet);
            if (newTaskSet.isErrors() || newTaskSet.getTaskData().isEmpty()) {
                XResultDataUI.report((XResultData)newTaskSet.getResults(), (String)this.getLabel());
            } else {
                AWorkbench.popup((String)"New Tasks Created");
            }
        }
    }

    protected void handleManualTask() {
        CreateTasksFromSimpleList operation = new CreateTasksFromSimpleList(this.teamWf, this.taskWorkDef);
        operation.setTeamWf(this.teamWf);
        BlamEditor.edit((AbstractBlam)operation);
    }

    protected List<XCheckBoxData> getCheckBoxes() {
        return Collections.castAll(this.getCheckBoxeWithTaskDatas());
    }

    protected abstract List<XCheckBoxesWithTaskGenData> getCheckBoxeWithTaskDatas();

    public List<XCheckBoxesWithTaskGenData> getLoadedCheckboxeWithTaskGenData() {
        if (this.checkBoxesWithTasks == null) {
            this.checkBoxesWithTasks = this.getCheckBoxeWithTaskDatas();
        }
        return this.checkBoxesWithTasks;
    }

    public List<XCheckBoxData> getLoadedCheckboxes() {
        return Collections.castAll(this.getLoadedCheckboxeWithTaskGenData());
    }

    public Artifact getArtifact() {
        return (Artifact)this.teamWf.getStoreObject();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsTeamWorkflow) {
            this.teamWf = (IAtsTeamWorkflow)artifact;
        }
    }

    protected String getTaskNameFormat() {
        return "%s";
    }

    public void refresh() {
        this.refreshEnablement();
    }
}

