/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;

public class WorkflowManager {
    public static boolean isAssigneeEditable(AbstractWorkflowArtifact awa) {
        return !awa.isCompletedOrCancelled() && !awa.isReadOnly() && awa.isAccessControlWrite();
    }

    public static List<TeamWorkFlowArtifact> getAllTeamWorkflowArtifacts() {
        ArrayList<TeamWorkFlowArtifact> result = new ArrayList<TeamWorkFlowArtifact>();
        for (ArtifactTypeToken artType : AtsArtifactTypes.TeamWorkflow.getAllDescendantTypes()) {
            List teamArts = Collections.castAll((Collection)ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)artType, (BranchId)AtsApiService.get().getAtsBranch()));
            result.addAll(teamArts);
        }
        return result;
    }

    public static Collection<AbstractWorkflowArtifact> filterOutState(Collection<AbstractWorkflowArtifact> awas, Collection<String> stateNames) {
        ArrayList<AbstractWorkflowArtifact> artifactsToReturn = new ArrayList<AbstractWorkflowArtifact>(awas.size());
        for (AbstractWorkflowArtifact awa : awas) {
            if (stateNames.contains(awa.getStateMgr().getCurrentStateName())) continue;
            artifactsToReturn.add(awa);
        }
        return artifactsToReturn;
    }

    public static Collection<AbstractWorkflowArtifact> filterOutCompleted(Collection<AbstractWorkflowArtifact> awas) {
        ArrayList<AbstractWorkflowArtifact> artifactsToReturn = new ArrayList<AbstractWorkflowArtifact>(awas.size());
        for (AbstractWorkflowArtifact awa : awas) {
            if (awa.isCompleted()) continue;
            artifactsToReturn.add(awa);
        }
        return artifactsToReturn;
    }

    public static Collection<AbstractWorkflowArtifact> filterOutCancelled(Collection<AbstractWorkflowArtifact> awas) {
        ArrayList<AbstractWorkflowArtifact> artifactsToReturn = new ArrayList<AbstractWorkflowArtifact>(awas.size());
        for (AbstractWorkflowArtifact awa : awas) {
            if (awa.isCancelled()) continue;
            artifactsToReturn.add(awa);
        }
        return artifactsToReturn;
    }

    public static Collection<Artifact> filterState(String selectedState, Collection<? extends Artifact> awas) {
        ArrayList<Artifact> artifactsToReturn = new ArrayList<Artifact>(awas.size());
        if (!Strings.isValid((String)selectedState)) {
            artifactsToReturn.addAll(awas);
        } else {
            for (Artifact artifact : awas) {
                if (!(artifact instanceof IAtsWorkItem) || !((IAtsWorkItem)artifact).getStateMgr().getCurrentStateName().equals(selectedState)) continue;
                artifactsToReturn.add(artifact);
            }
        }
        return artifactsToReturn;
    }

    public static Collection<AbstractWorkflowArtifact> filterOutTypes(Collection<AbstractWorkflowArtifact> awas, Collection<Class<?>> classes) {
        ArrayList<AbstractWorkflowArtifact> artifactsToReturn = new ArrayList<AbstractWorkflowArtifact>(awas.size());
        for (AbstractWorkflowArtifact awa : awas) {
            boolean found = false;
            for (Class<?> clazz : classes) {
                if (!clazz.isInstance((Object)awa)) continue;
                found = true;
            }
            if (found) continue;
            artifactsToReturn.add(awa);
        }
        return artifactsToReturn;
    }

    public static Collection<AbstractWorkflowArtifact> getTeamDefinitionWorkflows(Collection<? extends Artifact> artifacts, Collection<IAtsTeamDefinition> teamDefs) {
        ArrayList<AbstractWorkflowArtifact> returnawas = new ArrayList<AbstractWorkflowArtifact>();
        for (AbstractWorkflowArtifact awa : WorkflowManager.getAwas(artifacts)) {
            if (awa.getParentTeamWorkflow() == null || !teamDefs.contains(awa.getParentTeamWorkflow().getTeamDefinition())) continue;
            returnawas.add(awa);
        }
        return returnawas;
    }

    public static Collection<AbstractWorkflowArtifact> getVersionWorkflows(Collection<? extends Artifact> artifacts, Collection<IAtsVersion> versionArts) {
        ArrayList<AbstractWorkflowArtifact> returnawas = new ArrayList<AbstractWorkflowArtifact>();
        for (AbstractWorkflowArtifact awa : WorkflowManager.getAwas(artifacts)) {
            if (awa.getParentTeamWorkflow() == null || !AtsApiService.get().getVersionService().hasTargetedVersion((IAtsWorkItem)awa) || !versionArts.contains(AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)awa))) continue;
            returnawas.add(awa);
        }
        return returnawas;
    }

    public static Collection<AbstractWorkflowArtifact> getAwas(Collection<? extends Artifact> artifacts) {
        return Collections.castMatching(AbstractWorkflowArtifact.class, artifacts);
    }

    public static IAtsStateManager getStateManager(Artifact artifact) {
        return WorkflowManager.cast(artifact).getStateMgr();
    }

    public static AbstractWorkflowArtifact cast(Artifact artifact) {
        if (artifact instanceof AbstractWorkflowArtifact) {
            return (AbstractWorkflowArtifact)artifact;
        }
        return null;
    }

    public static StateXWidgetPage getCurrentAtsWorkPage(AbstractWorkflowArtifact awa) {
        for (StateXWidgetPage statePage : WorkflowManager.getStatePagesOrderedByOrdinal(awa)) {
            if (!awa.getStateMgr().getCurrentStateName().equals(statePage.getName())) continue;
            return statePage;
        }
        return null;
    }

    public static List<StateXWidgetPage> getStatePagesOrderedByOrdinal(IAtsWorkItem workItem) {
        ArrayList<StateXWidgetPage> statePages = new ArrayList<StateXWidgetPage>();
        if (workItem != null) {
            IAtsWorkDefinition workDef = workItem.getWorkDefinition();
            ATSXWidgetOptionResolver optionResolver = ATSXWidgetOptionResolver.getInstance();
            for (IAtsStateDefinition stateDefinition : AtsApiService.get().getWorkDefinitionService().getStatesOrderedByOrdinal(workDef)) {
                try {
                    StateXWidgetPage statePage = new StateXWidgetPage(workDef, stateDefinition, null, (IXWidgetOptionResolver)optionResolver, (AbstractWorkflowArtifact)workItem);
                    statePages.add(statePage);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
        return statePages;
    }
}

