/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.notify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.users.AtsUsersUtility;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.notify.EmailActionsData;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.EmailUtil;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonPush;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmailActionsBlam
extends AbstractBlam {
    public static final String ATS_WORKFLOWS = "ATS Workflows (drop here)";
    boolean includeCancelHyperlink;

    public String getName() {
        return "Email Message to Action(s) Assignees or Originator";
    }

    private EmailActionsData getEmailActionsData(final VariableMap variableMap) {
        final EmailActionsData data = new EmailActionsData();
        Displays.pendInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    data.getWorkflows().addAll(variableMap.getArtifacts(EmailActionsBlam.ATS_WORKFLOWS));
                    String recipientStr = variableMap.getString("Recipient");
                    if (Strings.isValid((String)recipientStr)) {
                        try {
                            EmailActionsData.EmailRecipient recipient = EmailActionsData.EmailRecipient.valueOf(recipientStr);
                            data.setEmailRecipient(recipient);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    data.setSubject(variableMap.getString("Subject"));
                    data.setBody(variableMap.getString("Body"));
                    EmailActionsBlam.this.includeCancelHyperlink = variableMap.getBoolean("Include Cancel Hyperlink");
                    data.setIncludeCancelHyperlink(EmailActionsBlam.this.includeCancelHyperlink);
                }
                catch (OseeArgumentException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
        return data;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        EmailActionsData data = this.getEmailActionsData(variableMap);
        Result result = data.isValid();
        if (result.isFalse()) {
            AWorkbench.popup((Result)result);
            return;
        }
        this.sendEmailNotifications(data);
    }

    private void sendEmailNotifications(EmailActionsData data) throws Exception {
        AtsNotificationCollector notifications = new AtsNotificationCollector();
        for (Artifact art : data.getWorkflows()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            this.addNotification(data, (AbstractWorkflowArtifact)art, notifications);
        }
        int sent = notifications.getNotificationEvents().size();
        notifications.setSubject(data.getSubject());
        notifications.setBody(data.getBody());
        notifications.setIncludeCancelHyperlink(data.isIncludeCancelHyperlink());
        AtsApiService.get().getNotificationService().sendNotifications(notifications);
        this.logf("Sent %s notifications.", new Object[]{sent});
    }

    private void addNotification(EmailActionsData data, AbstractWorkflowArtifact workItem, AtsNotificationCollector notifications) {
        Collection<AtsUser> recipients = this.getRecipients(data.getEmailRecipient(), workItem);
        Collection activeEmailUsers = AtsUsersUtility.getActiveEmailUsers(recipients);
        if (activeEmailUsers.isEmpty()) {
            this.logf("No active " + (Object)((Object)data.getEmailRecipient()) + " for workflow [%s].", new Object[]{workItem.toStringWithId()});
            return;
        }
        ArrayList<String> emailAddresses = new ArrayList<String>();
        for (AtsUser basicUser : activeEmailUsers) {
            if (!EmailUtil.isEmailValid((String)basicUser.getEmail())) continue;
            emailAddresses.add(basicUser.getEmail());
        }
        if (emailAddresses.isEmpty()) {
            this.logf("No valid emails for workflow [%s].", new Object[]{workItem.toStringWithId()});
            return;
        }
        if (!EmailUtil.isEmailValid((String)AtsApiService.get().getUserService().getCurrentUser().getEmail())) {
            this.logf("Can't email from user account [%s] cause email not valid.", new Object[]{AtsApiService.get().getUserService().getCurrentUser()});
            return;
        }
        AtsNotificationEvent notificationEvent = AtsNotificationEventFactory.getNotificationEvent((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), recipients, (String)EmailActionsBlam.getIdString(workItem), (String)data.getEmailRecipient().name(), (String)String.format("You are the %s of [%s] in state [%s] titled [%s] created on [%s]", data.getEmailRecipient().name(), workItem.getArtifactTypeName(), workItem.getStateMgr().getCurrentStateName(), workItem.getName(), DateUtil.get((Date)workItem.getCreatedDate(), (String)"MM/dd/yyyy hh:mm a")));
        notificationEvent.setUrl(AtsApiService.get().getWorkItemService().getHtmlUrl((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get()));
        if (this.includeCancelHyperlink) {
            if (AtsApiService.get().getWorkItemService().isCancelHyperlinkConfigured()) {
                notificationEvent.setCancelUrl(AtsApiService.get().getWorkItemService().getCancelUrl((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get()));
            } else {
                AWorkbench.popup((String)"CancelHyperlinkUrl not configured.  Can not include cancel link. Aborting...");
                return;
            }
        }
        notifications.addNotificationEvent(notificationEvent);
    }

    private Collection<AtsUser> getRecipients(EmailActionsData.EmailRecipient emailRecipient, AbstractWorkflowArtifact awa) {
        ArrayList<AtsUser> recipients = new ArrayList<AtsUser>();
        if (emailRecipient == EmailActionsData.EmailRecipient.Assignees) {
            try {
                recipients.addAll(awa.getAssignees());
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        } else if (emailRecipient == EmailActionsData.EmailRecipient.Originator) {
            try {
                AtsUser createdBy = awa.getCreatedBy();
                if (createdBy.isActive()) {
                    recipients.add(awa.getCreatedBy());
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        if (recipients.isEmpty()) {
            try {
                recipients.add(AtsApiService.get().getUserService().getCurrentUser());
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return recipients;
    }

    private static String getIdString(AbstractWorkflowArtifact sma) {
        try {
            String legacyPcrId = (String)sma.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, "");
            if (!legacyPcrId.equals("")) {
                return String.valueOf(sma.getAtsId()) + " / LegacyId: " + legacyPcrId;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return sma.getAtsId();
    }

    public void widgetCreating(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreating(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals("Preview Message")) {
            XButtonPush button = (XButtonPush)xWidget;
            button.setDisplayLabel(false);
        }
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"ATS Workflows (drop here)\" /><XWidget xwidgetType=\"XText\" displayName=\"Subject\" /><XWidget xwidgetType=\"XCombo(" + EmailActionsData.EmailRecipient.Assignees.toString() + "," + EmailActionsData.EmailRecipient.Originator.toString() + ")\" defaultValue=\"" + EmailActionsData.EmailRecipient.Assignees.toString() + "\" displayName=\"Recipient\" />" + "<XWidget xwidgetType=\"XText\" displayName=\"Body\" fill=\"Vertically\" />" + "<XWidget xwidgetType=\"XCheckBox\" displayName=\"Include Cancel Hyperlink\" labelAfter=\"true\" horizontalLabel=\"true\"/>" + "</xWidgets>";
    }

    public String getDescriptionUsage() {
        return "Loop through all dropped ATS Workflows and email to assignee(s) with message.  Note: User will get one email containing all items they are assigned/originated.  Note: Body is plain text and will be shown as is.";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_UTIL);
    }
}

