/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.notify;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.notify.AtsNotificationManagerUI;
import org.eclipse.osee.ats.ide.util.Overview;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.jdk.core.util.EmailGroup;
import org.eclipse.osee.framework.ui.skynet.util.email.EmailWizard;

public class ArtifactEmailWizard
extends EmailWizard {
    public ArtifactEmailWizard(AbstractWorkflowArtifact sma) {
        this(sma, null);
    }

    public ArtifactEmailWizard(AbstractWorkflowArtifact sma, List<Object> toAddress) {
        super(AtsNotificationManagerUI.getPreviewHtml(sma, Overview.PreviewStyle.HYPEROPEN, Overview.PreviewStyle.NO_SUBSCRIBE_OR_FAVORITE), " Regarding " + sma.getArtifactTypeName() + " - " + sma.getName(), ArtifactEmailWizard.getEmailableGroups(sma), toAddress);
    }

    public static List<EmailGroup> getEmailableGroups(IAtsWorkItem workItem) {
        ArrayList<EmailGroup> groupNames = new ArrayList<EmailGroup>();
        ArrayList<String> emails = new ArrayList<String>();
        emails.add(workItem.getCreatedBy().getEmail());
        groupNames.add(new EmailGroup("Originator", emails));
        if (workItem.getStateMgr().getAssignees().size() > 0) {
            emails = new ArrayList();
            for (AtsUser user : workItem.getStateMgr().getAssignees()) {
                if (!user.isActive()) continue;
                emails.add(user.getEmail());
            }
            groupNames.add(new EmailGroup("Assignees", emails));
        }
        return groupNames;
    }
}

