/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.editor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.ui.skynet.results.table.IResultsXViewerRow;

public class AtsConfigContentProvider
implements ITreeContentProvider {
    protected Collection<IResultsXViewerRow> rootSet = new HashSet<IResultsXViewerRow>();
    private static Object[] EMPTY_ARRAY = new Object[0];

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IResultsXViewerRow) {
            IResultsXViewerRow row = (IResultsXViewerRow)parentElement;
            Object data = row.getData();
            if (data instanceof IAtsTeamDefinition) {
                return this.getTeamDefChildren(data);
            }
            if (data instanceof IAtsActionableItem) {
                return this.getActionableItemChildren(data);
            }
        }
        if (parentElement instanceof IAtsTeamDefinition) {
            return this.getTeamDefChildren(parentElement);
        }
        if (parentElement instanceof IAtsActionableItem) {
            return this.getActionableItemChildren(parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getActionableItemChildren(Object data) {
        IAtsActionableItem aia = (IAtsActionableItem)data;
        LinkedList<IAtsTeamDefinition> children = new LinkedList<IAtsTeamDefinition>();
        children.addAll(aia.getChildrenActionableItems());
        if (aia.getTeamDefinition() != null) {
            children.add(aia.getTeamDefinition());
        }
        return children.toArray();
    }

    private Object[] getTeamDefChildren(Object data) {
        IAtsTeamDefinition teamDef = (IAtsTeamDefinition)data;
        LinkedList children = new LinkedList();
        children.addAll(AtsApiService.get().getTeamDefinitionService().getChildrenTeamDefinitions(teamDef));
        children.addAll(AtsApiService.get().getActionableItemService().getActionableItems(teamDef));
        children.addAll(AtsApiService.get().getVersionService().getVersions(teamDef));
        return children.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            return new Object[]{inputElement};
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

