/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class RelatedArtifactChangedColumn
extends XViewerAtsColumn
implements IAtsXViewerPreComputedColumn {
    public static RelatedArtifactChangedColumn instance = new RelatedArtifactChangedColumn();

    public static RelatedArtifactChangedColumn getInstance() {
        return instance;
    }

    private RelatedArtifactChangedColumn() {
        super("ats.column.RelatedArtifactChangedColumn", "Related Artifact Changed", 75, XViewerAlign.Left, false, SortDataType.String, false, "Committed - baseline/committed branch \nUnmodified - Related artifact has not changed \n<date> - Related artifact has been modified after task at the specified date \nEmpty - There is no related artifact");
    }

    public RelatedArtifactChangedColumn copy() {
        RelatedArtifactChangedColumn newXCol = new RelatedArtifactChangedColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        for (Object object : objects) {
            String value = "";
            try {
                Artifact refArt;
                ArtifactId refArtId;
                if (object instanceof Artifact && (refArtId = (ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(object).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL)).isValid() && (refArt = AtsApiService.get().getQueryServiceIde().getArtifact(refArtId)) != null) {
                    BranchToken refBranch = refArt.getBranch();
                    value = refArt.isDeleted() ? "Deleted" : (BranchManager.getState((BranchId)refBranch).isCommitted() || BranchManager.getType((BranchId)refBranch).isBaselineBranch() ? "Commited" : (refArt.getLastModified().after(AtsApiService.get().getQueryServiceIde().getArtifact(object).getLastModified()) ? refArt.getLastModified().toString() : "Unmodified"));
                }
            }
            catch (OseeCoreException ex) {
                value = LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
            Long key = this.getKey(object);
            preComputedValueMap.put(key, value);
        }
    }
}

