/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.ide.actions.wizard.IAtsWizardItem;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionWizard;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class NewActionPage3
extends WizardPage {
    private XWidgetPage page;
    private Composite comp;
    protected final NewActionWizard wizard;
    private static Set<IAtsWizardItem> wizardExtensionItems = new HashSet<IAtsWizardItem>();
    private final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            NewActionPage3.this.getContainer().updateButtons();
        }
    };

    public NewActionPage3(NewActionWizard wizard) {
        this(wizard, "Create new ATS Action", "Create ATS Action");
    }

    public NewActionPage3(NewActionWizard wizard, String pageName, String title) {
        super(pageName, title, null);
        this.wizard = wizard;
        this.setMessage("Enter requested information and select Finish.");
        NewActionPage3.getWizardXWidgetExtensions();
    }

    public void notifyAtsWizardItemExtensions(ActionResult actionResult, IAtsChangeSet changes) {
        for (IAtsWizardItem item : wizardExtensionItems) {
            try {
                if (!item.hasWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems())) continue;
                item.wizardCompleted(actionResult, changes);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.createPage(this.comp);
        this.getShell().layout();
    }

    public void createPage(Composite comp) {
        try {
            if (this.page == null) {
                boolean hasWizardXWidgetExtensions;
                StringBuffer stringBuffer = new StringBuffer(500);
                stringBuffer.append("<WorkPage>");
                IDynamicWidgetLayoutListener dynamicWidgetLayoutListener = null;
                for (IAtsWizardItem item : wizardExtensionItems) {
                    hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems());
                    if (!hasWizardXWidgetExtensions) continue;
                    stringBuffer.append("<XWidget displayName=\"--- Extra fields for " + item.getName() + " ---\" xwidgetType=\"XLabel\" horizontalLabel=\"true\" toolTip=\"These fields are available for only the team workflow specified here.\"/>");
                    try {
                        if (item instanceof IDynamicWidgetLayoutListener) {
                            dynamicWidgetLayoutListener = (IDynamicWidgetLayoutListener)item;
                        }
                        item.getWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems(), stringBuffer);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
                stringBuffer.append("</WorkPage>");
                this.page = new XWidgetPage(stringBuffer.toString(), (IXWidgetOptionResolver)ATSXWidgetOptionResolver.getInstance(), dynamicWidgetLayoutListener);
                this.page.createBody(null, comp, null, this.xModListener, true);
                for (IAtsWizardItem item : wizardExtensionItems) {
                    hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems());
                    if (!hasWizardXWidgetExtensions) continue;
                    item.getWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems(), comp);
                }
                comp.layout();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void createControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)this.comp);
    }

    public void update() {
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        if (this.page == null || !this.page.isPageComplete().isTrue()) {
            return false;
        }
        for (IAtsWizardItem item : wizardExtensionItems) {
            try {
                Result result;
                if (!item.hasWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems()) || !(result = item.isWizardXWidgetsComplete(this.wizard)).isFalse()) continue;
                this.setErrorMessage(result.getText());
                return false;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public XWidget getXWidget(String attrName) {
        Conditions.checkNotNull((Object)this.page, (String)"WorkPage");
        return this.page.getLayoutData(attrName).getXWidget();
    }

    public static Set<IAtsWizardItem> getWizardXWidgetExtensions() {
        IExtension[] extensions;
        if (!wizardExtensionItems.isEmpty()) {
            return wizardExtensionItems;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.AtsWizardItem");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access AtsWizardItem extension point");
            return wizardExtensionItems;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("AtsWizardItem")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            wizardExtensionItems.add((IAtsWizardItem)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading AtsWizardItem extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return wizardExtensionItems;
    }

    public static boolean isPage3Necesary(Collection<IAtsActionableItem> aias) {
        NewActionPage3.getWizardXWidgetExtensions();
        for (IAtsWizardItem item : wizardExtensionItems) {
            try {
                if (!item.hasWizardXWidgetExtensions(aias)) continue;
                return true;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return false;
    }

    public Result isActionValid() {
        NewActionPage3.getWizardXWidgetExtensions();
        for (IAtsWizardItem item : wizardExtensionItems) {
            try {
                Result result;
                if (!item.hasWizardXWidgetExtensions(this.wizard.getSelectedIAtsActionableItems()) || !(result = item.isActionValidToCreate(this.wizard.getSelectedIAtsActionableItems(), this.wizard)).isFalse()) continue;
                return result;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return Result.TrueResult;
    }
}

