/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.ide.traceability.AbstractSourceTagger;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public class TestUnitTagger
extends AbstractSourceTagger {
    private static final String ANNOTATION_STRING = "@ObjectId(\"%s\")\n";
    private static final String IMPORT_STRING = "\nimport org.eclipse.osee.framework.jdk.core.type.ObjectId;";
    private static final Pattern classPattern = Pattern.compile("public.*?\\s+class\\s+", 32);
    public static final Pattern ANNOTATION_PATTERN = Pattern.compile("@ObjectId\\s*\\(\"(.*?)\"\\s*\\)");
    private static final Pattern importPattern = Pattern.compile("import org\\.eclipse\\.osee\\.framework\\.jdk\\.core\\.type\\.ObjectId;");
    private static final Pattern importBlockPattern = Pattern.compile("(\\s*import\\s.*;)+");
    private final Matcher classMatcher = classPattern.matcher("");
    private final Matcher annotationMatcher = ANNOTATION_PATTERN.matcher("");
    private final Matcher importMatcher = importPattern.matcher("");
    private final Matcher importBlockMatcher = importBlockPattern.matcher("");
    private static final TestUnitTagger instance = new TestUnitTagger();

    private TestUnitTagger() {
    }

    public static TestUnitTagger getInstance() {
        return instance;
    }

    @Override
    public String getSourceTag(CharBuffer buffer) {
        String toReturn = null;
        this.annotationMatcher.reset(buffer);
        if (this.annotationMatcher.find()) {
            toReturn = this.annotationMatcher.group(1);
        }
        return toReturn;
    }

    private CharBuffer addImportStatement(CharBuffer buffer) {
        this.importMatcher.reset(buffer);
        if (this.importMatcher.find()) {
            return buffer;
        }
        CharBuffer copy = buffer.duplicate();
        this.importBlockMatcher.reset(copy);
        ChangeSet changeSet = new ChangeSet((CharSequence)copy);
        int position = 0;
        if (this.importBlockMatcher.find()) {
            position = this.importBlockMatcher.end();
            changeSet.insertBefore(position, IMPORT_STRING);
        }
        return CharBuffer.wrap(changeSet.applyChangesToSelf().toString().toCharArray());
    }

    @Override
    public CharBuffer addSourceTag(CharBuffer buffer, String guid) {
        buffer = this.removeSourceTag(buffer);
        buffer = this.addImportStatement(buffer);
        this.classMatcher.reset(buffer);
        if (this.classMatcher.find()) {
            String classDeclaration = this.classMatcher.group();
            int start = this.classMatcher.start();
            int stop = this.classMatcher.end();
            ChangeSet changeSet = new ChangeSet((CharSequence)buffer);
            changeSet.replace(start, stop, String.valueOf(String.format(ANNOTATION_STRING, guid)) + classDeclaration);
            return CharBuffer.wrap(changeSet.applyChangesToSelf().toString().toCharArray());
        }
        return buffer;
    }

    @Override
    public CharBuffer removeSourceTag(CharBuffer buffer) {
        buffer = this.removeMatches(buffer, this.importMatcher);
        buffer = this.removeMatches(buffer, this.annotationMatcher);
        return buffer;
    }
}

