/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureEndpointImpl
implements InterfaceStructureEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceStructureEndpointImpl(BranchId branch, UserId accountId, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = accountId;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getAllStructures() {
        try {
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                InterfaceStructureToken interfaceStructureToken = this.parseStructure(structure);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceStructureToken getStructure(ArtifactId structureId) {
        InterfaceStructureToken returnValue = new InterfaceStructureToken();
        try {
            returnValue = this.interfaceStructureApi.getAccessor().getByRelation(this.branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            returnValue = this.parseStructure(returnValue);
            return returnValue;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return returnValue;
        }
    }

    private InterfaceStructureElementToken defaultSetUpElement(InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        try {
            PlatformTypeToken tempPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
            element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
            element.setBeginWord(Math.floor(previousElement.getEndByte() == 3.0 ? previousElement.getEndWord() + 1.0 : previousElement.getEndWord()));
            element.setInterfacePlatformTypeBitSize(tempPlatformType.getInterfacePlatformTypeBitSize());
            element.setPlatformTypeId(tempPlatformType.getId());
            element.setPlatformTypeName(tempPlatformType.getName());
            element.setLogicalType(tempPlatformType.getInterfaceLogicalType() != null ? tempPlatformType.getInterfaceLogicalType() : "");
            element.setInterfacePlatformTypeMinval(tempPlatformType.getInterfacePlatformTypeMinval() != null ? tempPlatformType.getInterfacePlatformTypeMinval() : "");
            element.setInterfacePlatformTypeMaxval(tempPlatformType.getInterfacePlatformTypeMaxval() != null ? tempPlatformType.getInterfacePlatformTypeMaxval() : "");
            element.setInterfacePlatformTypeDefaultValue(tempPlatformType.getInterfacePlatformTypeDefaultValue() != null ? tempPlatformType.getInterfacePlatformTypeDefaultValue() : "");
            element.setUnits(tempPlatformType.getInterfacePlatformTypeUnits() != null ? tempPlatformType.getInterfacePlatformTypeUnits() : "");
        }
        catch (Exception exception) {}
        return element;
    }

    private InterfaceStructureToken parseStructure(InterfaceStructureToken structure) {
        try {
            LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
            elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
            LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
            if (elements.size() >= 2) {
                Iterator elementIterator = elements.iterator();
                InterfaceStructureElementToken previousElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                InterfaceStructureElementToken currentElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                PlatformTypeToken previousPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)previousElement.getId()), PlatformTypeToken.class);
                previousElement.setInterfacePlatformTypeBitSize(previousPlatformType.getInterfacePlatformTypeBitSize());
                previousElement.setBeginByte(0.0);
                previousElement.setBeginWord(0.0);
                previousElement.setPlatformTypeId(previousPlatformType.getId());
                previousElement.setPlatformTypeName(previousPlatformType.getName());
                previousElement.setLogicalType(previousPlatformType.getInterfaceLogicalType() != null ? previousPlatformType.getInterfaceLogicalType() : "");
                previousElement.setInterfacePlatformTypeMinval(previousPlatformType.getInterfacePlatformTypeMinval() != null ? previousPlatformType.getInterfacePlatformTypeMinval() : "");
                previousElement.setInterfacePlatformTypeMaxval(previousPlatformType.getInterfacePlatformTypeMaxval() != null ? previousPlatformType.getInterfacePlatformTypeMaxval() : "");
                previousElement.setInterfacePlatformTypeDefaultValue(previousPlatformType.getInterfacePlatformTypeDefaultValue() != null ? previousPlatformType.getInterfacePlatformTypeDefaultValue() : "");
                previousElement.setUnits(previousPlatformType.getInterfacePlatformTypeUnits() != null ? previousPlatformType.getInterfacePlatformTypeUnits() : "");
                tempElements.add(previousElement);
                if (!elementIterator.hasNext()) {
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                while (elementIterator.hasNext()) {
                    InterfaceStructureElementToken nextElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                    if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                        if (previousElement.getEndByte() != 3.0) {
                            previousElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", Math.floor((previousElement.getEndByte() + 1.0) % 4.0), previousElement.getEndWord(), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                            tempElements.add(previousElement);
                        }
                        if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                            previousElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, previousElement.getEndWord() + 1.0, (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                            tempElements.add(previousElement);
                        }
                        currentElement = this.defaultSetUpElement(currentElement, previousElement);
                    }
                    tempElements.add(currentElement);
                    previousElement = currentElement;
                    currentElement = nextElement;
                }
                if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                    if (previousElement.getEndByte() != 3.0) {
                        previousElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", Math.floor((previousElement.getEndByte() + 1.0) % 4.0), previousElement.getEndWord(), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                        tempElements.add(previousElement);
                    }
                    if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                        previousElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, previousElement.getEndWord() + 1.0, (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                        tempElements.add(previousElement);
                    }
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                tempElements.add(currentElement);
                if (currentElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", currentElement.getEndByte() + 1.0, currentElement.getEndWord(), (int)Math.floor(3.0 - currentElement.getEndByte()), true));
                }
                if (currentElement.getEndWord() % 2.0 != 1.0) {
                    currentElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, currentElement.getEndWord() + 1.0, 3);
                    tempElements.add(currentElement);
                }
                structure.setElements(tempElements);
            } else {
                InterfaceStructureElementToken lastElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", 0.0, 0.0, 0);
                for (InterfaceStructureElementToken element : elements) {
                    element.setBeginByte(0.0);
                    element.setBeginWord(0.0);
                    PlatformTypeToken currentPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(currentPlatformType.getId());
                    element.setPlatformTypeName(currentPlatformType.getName());
                    element.setInterfacePlatformTypeBitSize(currentPlatformType.getInterfacePlatformTypeBitSize());
                    element.setLogicalType(currentPlatformType.getInterfaceLogicalType() != null ? currentPlatformType.getInterfaceLogicalType() : "");
                    element.setInterfacePlatformTypeMinval(currentPlatformType.getInterfacePlatformTypeMinval() != null ? currentPlatformType.getInterfacePlatformTypeMinval() : "");
                    element.setInterfacePlatformTypeMaxval(currentPlatformType.getInterfacePlatformTypeMaxval() != null ? currentPlatformType.getInterfacePlatformTypeMaxval() : "");
                    element.setInterfacePlatformTypeDefaultValue(currentPlatformType.getInterfacePlatformTypeDefaultValue() != null ? currentPlatformType.getInterfacePlatformTypeDefaultValue() : "");
                    element.setUnits(currentPlatformType.getInterfacePlatformTypeUnits() != null ? currentPlatformType.getInterfacePlatformTypeUnits() : "");
                    lastElement = element;
                }
                tempElements.addAll(elements);
                if (lastElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", lastElement.getEndByte() + 1.0, lastElement.getEndWord(), (int)Math.floor(3.0 - lastElement.getEndByte()), true));
                }
                if (lastElement.getEndWord() % 2.0 != 1.0) {
                    lastElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, lastElement.getEndWord() + 1.0, 3);
                    tempElements.add(lastElement);
                }
                structure.setElements(tempElements);
            }
        }
        catch (Exception exception) {}
        return structure;
    }
}

