/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.osee.synchronization.rest.DuplicateGroveEntry;
import org.eclipse.osee.synchronization.rest.Grove;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.util.HierarchyTree;

public abstract class AbstractHierarchyTreeGrove
implements Grove {
    protected final IdentifierType identifierType;
    protected final Map<IdentifierType.Identifier, HierarchyTree<IdentifierType.Identifier, GroveThing>> hierarchyTrees;
    protected final Map<Long, GroveThing> nativeKeyMap;

    public AbstractHierarchyTreeGrove(IdentifierType identifierType) {
        this.identifierType = Objects.requireNonNull(identifierType);
        this.hierarchyTrees = new HashMap<IdentifierType.Identifier, HierarchyTree<IdentifierType.Identifier, GroveThing>>();
        this.nativeKeyMap = new HashMap<Long, GroveThing>();
    }

    @Override
    public void add(GroveThing groveThing) {
        Objects.requireNonNull(groveThing);
        IdentifierType.Identifier groveThingKey = groveThing.getGroveThingKey();
        if (this.hierarchyTrees.containsKey(groveThingKey)) {
            throw new DuplicateGroveEntry(this, groveThing);
        }
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = new HierarchyTree<IdentifierType.Identifier, GroveThing>();
        this.hierarchyTrees.put(groveThingKey, hierarchyTree);
        hierarchyTree.setRoot(groveThingKey, groveThing);
        groveThing.getNativeKey().ifPresent(nativeKey -> {
            GroveThing groveThing2 = this.nativeKeyMap.put((Long)nativeKey, groveThing);
        });
    }

    public void add(IdentifierType.Identifier treeKey, IdentifierType.Identifier parentKey, GroveThing groveThing) {
        Objects.requireNonNull(treeKey);
        Objects.requireNonNull(parentKey);
        Objects.requireNonNull(groveThing);
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(treeKey);
        assert (Objects.nonNull(hierarchyTree));
        IdentifierType.Identifier groveThingKey = groveThing.getGroveThingKey();
        if (hierarchyTree.containsKey(groveThingKey)) {
            throw new DuplicateGroveEntry(this, groveThing);
        }
        hierarchyTree.insertLast(parentKey, groveThingKey, groveThing);
        groveThing.getNativeKey().ifPresent(nativeKey -> {
            GroveThing groveThing2 = this.nativeKeyMap.put((Long)nativeKey, groveThing);
        });
    }

    @Override
    public boolean contains(Long nativeKey) {
        return this.nativeKeyMap.containsKey(nativeKey);
    }

    @Override
    public void createForeignThings(SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        Optional<Consumer<GroveThing>> converterOptional = synchronizationArtifactBuilder.getConverter(this.identifierType);
        converterOptional.ifPresent(converter -> this.stream().forEach(converter::accept));
    }

    public void forEachGroveThing(IdentifierType.Identifier treeKey, BiConsumer<IdentifierType.Identifier, IdentifierType.Identifier> biConsumer) {
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(treeKey);
        hierarchyTree.forEach(biConsumer);
    }

    @Override
    public Optional<GroveThing> getByNativeKey(Long nativeKey) {
        return Optional.ofNullable(this.nativeKeyMap.get(nativeKey));
    }

    @Override
    public IdentifierType getType() {
        return this.identifierType;
    }

    @Override
    public Stream<GroveThing> stream() {
        return this.hierarchyTrees.values().stream().flatMap(HierarchyTree::stream);
    }

    public Stream<IdentifierType.Identifier> streamGroveThingChildKeys(IdentifierType.Identifier treeKey, IdentifierType.Identifier parentKey) {
        assert (Objects.nonNull(treeKey) && Objects.nonNull(parentKey));
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(treeKey);
        assert (Objects.nonNull(hierarchyTree));
        assert (hierarchyTree.containsKey(parentKey));
        hierarchyTree.setCurrent(parentKey);
        return hierarchyTree.streamChildKeys();
    }

    public Stream<IdentifierType.Identifier> streamRootGroveThingKeys() {
        return this.hierarchyTrees.keySet().stream();
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        return null;
    }
}

