/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaRelation2;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class RelationSqlHandler2
extends SqlHandler<CriteriaRelation2> {
    private CriteriaRelation2 criteria;
    private String jTypeIdAlias;
    private String jArtAlias;
    private String relationAlias;
    private String txsAlias;
    private Collection<RelationTypeToken> typeIds;
    private AbstractJoinQuery joinTypeQuery;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATION_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaRelation2 criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.writeCommaIfNotFirst();
        writer.write("%s.rel_type, %s.a_art_id, %s.b_art_id, %s.rel_art_id, %s.rel_order", this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.jArtAlias = writer.addTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        this.typeIds = this.getLocalTypeIds();
        if (this.typeIds.size() > 1) {
            this.jTypeIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        }
        this.relationAlias = writer.addTable(OseeDb.RELATION_TABLE2);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.RELATION);
    }

    private Collection<RelationTypeToken> getLocalTypeIds() {
        HashSet<RelationTypeToken> toReturn = new HashSet<RelationTypeToken>();
        for (RelationTypeToken relationTypeToken : this.criteria.getTypes()) {
            toReturn.add(relationTypeToken);
        }
        return toReturn;
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write("(%s.a_art_id = %s.id2 OR %s.b_art_id = %s.id2)", this.relationAlias, this.jArtAlias, this.relationAlias, this.jArtAlias);
        writer.write(" AND ");
        writer.write(this.jArtAlias);
        writer.write(".query_id = ?");
        writer.addParameter(this.criteria.getQueryId());
        if (!this.typeIds.isEmpty()) {
            writer.write(" AND ");
            if (this.typeIds.size() > 1) {
                this.joinTypeQuery = writer.writeJoin(this.typeIds);
                writer.write(this.relationAlias);
                writer.write(".rel_type = ");
                writer.write(this.jTypeIdAlias);
                writer.write(".id AND ");
                writer.write(this.jTypeIdAlias);
                writer.write(".query_id = ?");
                writer.addParameter(this.joinTypeQuery.getQueryId());
            } else {
                writer.write(this.relationAlias);
                writer.write(".rel_type = ?");
                writer.addParameter(this.typeIds.iterator().next());
            }
        }
        writer.write(" AND ");
        writer.write(this.relationAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.write("\n AND ");
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

