/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.conflict;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.model.change.ChangeItem;

public class ComputeConflictsCallable
extends CancellableCallable<Object> {
    private final Collection<ChangeItem> changes;
    private final Map<ChangeItem, ConflictStatus> conflicts;

    public ComputeConflictsCallable(Collection<ChangeItem> changes, Map<ChangeItem, ConflictStatus> conflicts) {
        this.changes = changes;
        this.conflicts = conflicts;
    }

    public Object call() throws Exception {
        if (!this.changes.isEmpty()) {
            Iterator<ChangeItem> iterator = this.changes.iterator();
            while (iterator.hasNext()) {
                this.checkForCancelled();
                ChangeItem change = iterator.next();
                ConflictStatus conflictStatus = this.getConflictStatus(change);
                if (!conflictStatus.isConflict()) continue;
                this.conflicts.put(change, conflictStatus);
            }
        }
        return null;
    }

    private ConflictStatus getConflictStatus(ChangeItem change) {
        ConflictStatus conflictStatus = ConflictStatus.NOT_CONFLICTED;
        if (change.getDestinationVersion().isValid()) {
            change.getCurrentVersion().getGammaId();
            change.getDestinationVersion().getGammaId();
            change.getDestinationVersion().getGammaId();
            change.getBaselineVersion().getGammaId();
        }
        return conflictStatus;
    }
}

