/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.OwFactory;
import org.eclipse.osee.orcs.rest.model.writer.OrcsWriterToken;
import org.eclipse.osee.orcs.rest.model.writer.config.OrcsWriterInputConfig;
import org.eclipse.osee.orcs.rest.model.writer.config.OrcsWriterRelationSide;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwApplicability;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwBranch;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsWriterCollectorGenerator {
    private OrcsApi orcsApi;
    private final OrcsWriterInputConfig config;
    private OwCollector collector;

    public OrcsWriterCollectorGenerator() {
        this(null);
    }

    public OrcsWriterCollectorGenerator(OrcsWriterInputConfig config) {
        this.config = config;
    }

    private void init(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.collector = new OwCollector();
    }

    public OwCollector run(OrcsApi providedOrcs) {
        this.init(providedOrcs);
        this.collector.setPersistComment("Put Comment Here");
        this.collector.setAsUserId(SystemUser.OseeSystem.getUserId());
        this.collector.getBranch().setName(CoreBranches.COMMON.getName());
        this.collector.getBranch().setId(CoreBranches.COMMON.getId());
        this.collector.setBranchId((BranchId)CoreBranches.COMMON);
        this.collector.getBranch().setData(String.format("[%s]-[%s]", CoreBranches.COMMON.getName(), CoreBranches.COMMON.getId()));
        this.createInstructions();
        this.createCreateSheet();
        this.createUpdateSheet();
        this.createDeleteSheet();
        this.createBranchSheet();
        this.createArtifactTokenSheet();
        this.createArtifactTypeSheet();
        this.createAttributeTypeSheet();
        this.createRelationTypeSheet();
        return this.collector;
    }

    private void createInstructions() {
        StringBuilder sb = new StringBuilder();
        sb.append("ORCS Writer provides Create, Update and Delete capabilities through JSON or an Excel spreadsheet\n");
        sb.append("   - Download an Example Excel Workbook (<server>/orcs/writer/sheet) or ");
        sb.append("Example JSON (<server>/orcs/writer/sheet.json)\n");
        sb.append("   - Make modifications to the input. CREATE, MODIFY, DELETE, BRANCH tabs/structures are the only items\n");
        sb.append("     that will be read. Token and Type tabs/structures are for reference only and should be used\n");
        sb.append("     in the CREATE, MODIFY and DELETE tabs/structures.\n");
        sb.append("   - On BRANCH tab, delete all but the single branch to apply changes to.\n");
        sb.append("   - Use <server>/orcs/writer/ui/main.html to validate sheet/json and then apply changes to branch.");
        this.collector.setInstructions(sb.toString());
    }

    private void createCreateSheet() {
        ArtifactToken folder = this.createFolder();
        this.createSoftwareRequirement(folder, "1");
        this.createSoftwareRequirement(folder, "2");
        this.createMSWordRequirement(folder, "3");
    }

    private void createMSWordRequirement(ArtifactToken folderToken, String number) {
        Long reqId = Lib.generateArtifactIdAsInt();
        String name = "MSWordRequirement" + number;
        OwArtifact wordReq = OwFactory.createArtifact(CoreArtifactTypes.CustomerRequirementMsWord, name, reqId);
        OwApplicability owApp = OwFactory.createApplicability("Base");
        wordReq.setAppId(owApp);
        OwFactory.createAttribute(wordReq, (AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, "WordTemplate Content field " + number);
        this.collector.getCreate().add(wordReq);
        OwRelation relation = new OwRelation();
        relation.setType(OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.DefaultHierarchical_Parent));
        relation.setArtToken(folderToken);
        wordReq.getRelations().add(relation);
    }

    private void createSoftwareRequirement(ArtifactToken folderToken, String number) {
        Long reqId = Lib.generateArtifactIdAsInt();
        String name = "Software Requirement " + number;
        OwArtifact softwareReq = OwFactory.createArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, name, reqId);
        OwApplicability owApp = OwFactory.createApplicability("Base");
        softwareReq.setAppId(owApp);
        OwFactory.createAttribute(softwareReq, (AttributeTypeToken)CoreAttributeTypes.StaticId, "static id field " + number);
        this.collector.getCreate().add(softwareReq);
        OwRelation relation = new OwRelation();
        relation.setType(OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.DefaultHierarchical_Parent));
        relation.setArtToken(folderToken);
        softwareReq.getRelations().add(relation);
    }

    private ArtifactToken createFolder() {
        Long folderId = Lib.generateArtifactIdAsInt();
        String folderName = "Orcs Writer Import Folder";
        OwArtifact folder = OwFactory.createArtifact(CoreArtifactTypes.Folder, folderName, folderId);
        this.collector.getCreate().add(folder);
        OwRelation relation = new OwRelation();
        relation.setType(OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.DefaultHierarchical_Parent));
        relation.setArtToken((ArtifactToken)OwFactory.createArtifactToken(CoreArtifactTokens.DefaultHierarchyRoot));
        folder.getRelations().add(relation);
        return OwFactory.createArtifactToken(folderName, folderId);
    }

    private void createUpdateSheet() {
        OwArtifact userGroupArt = OwFactory.createArtifact(CoreArtifactTypes.Folder, CoreArtifactTokens.UserGroups.getName(), CoreArtifactTokens.UserGroups.getId());
        OwFactory.createAttribute(userGroupArt, (AttributeTypeToken)CoreAttributeTypes.StaticId, "test static id");
        OwFactory.createAttribute(userGroupArt, (AttributeTypeToken)CoreAttributeTypes.Annotation, "test annotation");
        this.collector.getUpdate().add(userGroupArt);
    }

    private void createDeleteSheet() {
        this.collector.getDelete();
    }

    private void createArtifactTokenSheet() {
        if (this.config == null) {
            OwArtifactToken owToken = OwFactory.createArtifactToken(CoreArtifactTokens.DefaultHierarchyRoot);
            this.collector.getArtTokens().add(owToken);
        } else {
            for (OrcsWriterToken token : this.config.getIncludeTokens()) {
                OwArtifactToken owToken = OwFactory.createArtifactToken(token.getName(), token.getId());
                this.collector.getArtTokens().add(owToken);
            }
        }
    }

    private void createArtifactTypeSheet() {
        HashMap<String, ArtifactTypeToken> types = new HashMap<String, ArtifactTypeToken>(100);
        if (this.config == null) {
            for (ArtifactTypeToken type : this.orcsApi.tokenService().getArtifactTypes()) {
                types.put(type.getName(), type);
            }
        } else {
            for (Long typeId : this.config.getIncludeArtifactTypes()) {
                ArtifactTypeToken type = this.orcsApi.tokenService().getArtifactType(typeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            ArtifactTypeToken type = (ArtifactTypeToken)types.get(typeName);
            OwArtifactType owType = OwFactory.createArtifactType(type);
            this.collector.getArtTypes().add(owType);
        }
    }

    private void createBranchSheet() {
        HashMap<String, BranchToken> branches = new HashMap<String, BranchToken>(500);
        for (BranchToken branch : this.orcsApi.getQueryFactory().branchQuery().getResults()) {
            branches.put(branch.getName(), branch);
        }
        ArrayList branchNames = new ArrayList();
        branchNames.addAll(branches.keySet());
        Collections.sort(branchNames);
        for (String branchName : branchNames) {
            BranchToken type = (BranchToken)branches.get(branchName);
            OwBranch owBranch = OwFactory.createBranchToken(type);
            this.collector.getBranches().add(owBranch);
        }
    }

    private void createAttributeTypeSheet() {
        HashMap<String, Object> types = new HashMap<String, Object>(100);
        if (this.config == null) {
            for (AttributeTypeToken type : this.orcsApi.tokenService().getAttributeTypes()) {
                types.put(type.getName(), type);
            }
        } else {
            for (Long typeId : this.config.getIncludeAttributeTypes()) {
                AttributeTypeGeneric type = this.orcsApi.tokenService().getAttributeType(typeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            AttributeTypeToken type = (AttributeTypeToken)types.get(typeName);
            OwAttributeType owType = OwFactory.createAttributeType(type);
            this.collector.getAttrTypes().add(owType);
        }
    }

    private void createRelationTypeSheet() {
        RelationTypeToken type;
        HashMap<String, RelationTypeToken> types = new HashMap<String, RelationTypeToken>(100);
        if (this.config == null) {
            for (RelationTypeToken type2 : this.orcsApi.tokenService().getRelationTypes()) {
                types.put(type2.getName(), type2);
            }
        } else {
            for (OrcsWriterRelationSide token : this.config.getIncludeRelationTypes()) {
                Long relationTypeId = token.getRelationTypeId();
                type = this.orcsApi.tokenService().getRelationType(relationTypeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            type = (RelationTypeToken)types.get(typeName);
            this.writeRelationType(type);
        }
    }

    private void writeRelationType(RelationTypeToken type) {
        String sideAName = type.getSideName(RelationSide.SIDE_A);
        OwRelationType owType = OwFactory.createRelationType(type, sideAName, true);
        this.collector.getRelTypes().add(owType);
        String sideBName = type.getSideName(RelationSide.SIDE_B);
        owType = OwFactory.createRelationType(type, sideBName, false);
        this.collector.getRelTypes().add(owType);
    }
}

