/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="UserDashboard")
public class UserDashboardResource
extends AbstractConfigResource {
    public UserDashboardResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.Project, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getUserSpecificTasks")
    public String getUserSpecificTasks(String json) {
        String serialize = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String userGuid = artifact.getUuid();
            String userId = artifact.getName();
            if (userGuid != null) {
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                ResultSet projects = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Project}).getResults();
                for (ArtifactReadable project : projects) {
                    String shortname = ((AttributeReadable)project.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
                    QueryBuilder query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).and((AttributeTypeId)AtsAttributeTypes.CurrentStateType, "Working", QueryOption.EXACT_MATCH_OPTIONS).andRelatedTo(AtsRelationTypes.ProjectToTeamWorkFlow_Project, (ArtifactId)project);
                    ArtifactReadable userArtifact = CommonUtil.getUserFromGivenUserId(userId);
                    query = query.and((AttributeTypeId)AtsAttributeTypes.CurrentState, userArtifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId), new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY});
                    ResultSet results = query.getResults();
                    for (ArtifactReadable artifactReadable : results) {
                        TransferableArtifact ar = new TransferableArtifact();
                        ResultSet related = artifactReadable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
                        String workPackage = null;
                        if (artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).size() <= 0) continue;
                        workPackage = ((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                        TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelations(artifactReadable, ar);
                        String taskId = String.valueOf(shortname) + "-" + workPackage;
                        if (related.size() == 0) {
                            ar.putAttributes("Backlog", Arrays.asList("true"));
                        } else {
                            ar.putAttributes("Backlog", Arrays.asList("false"));
                            ar.putAttributes("SprintName", Arrays.asList(((ArtifactReadable)related.getExactlyOne()).getName()));
                        }
                        ar.putAttributes("TaskId", Arrays.asList(taskId));
                        ar.putAttributes("ProjectName", Arrays.asList(((ArtifactReadable)artifactReadable.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getName()));
                        listTras.add(ar);
                    }
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(listTras);
                serialize = gson.toJson((Object)container);
            }
            return serialize;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

