/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.account.admin.OseeOAuthContext;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.OseePermission;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;

@Provider
public class OseeOAuthContextProvider
implements ContextProvider<OseeOAuthContext> {
    public OseeOAuthContext createContext(Message message) {
        OseeOAuthContext toReturn = null;
        OAuthContext cxt = (OAuthContext)message.getContent(OAuthContext.class);
        if (cxt != null) {
            toReturn = OseeOAuthContextProvider.newOAuthContext(cxt);
        } else {
            SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
            Principal userPrincipal = sc.getUserPrincipal();
            OseePrincipal owner = null;
            if (userPrincipal instanceof OseePrincipal) {
                owner = (OseePrincipal)userPrincipal;
            }
            toReturn = OseeOAuthContextProvider.newOAuthContext(owner, null);
        }
        return toReturn;
    }

    private static OseeOAuthContext newOAuthContext(final OseePrincipal owner, final OseePrincipal client) {
        return new OseeOAuthContext(){

            public OseePrincipal getOwner() {
                return owner;
            }

            public OseePrincipal getClient() {
                return client;
            }

            public String getTokenGrantType() {
                return "N/A";
            }

            public String getClientId() {
                return "N/A";
            }

            public String getTokenKey() {
                return "N/A";
            }

            public String getTokenAudience() {
                return "N/A";
            }

            public List<OseePermission> getPermissions() {
                return Collections.emptyList();
            }
        };
    }

    private static OseeOAuthContext newOAuthContext(final OAuthContext ctx) {
        return new OseeOAuthContext(){

            public OseePrincipal getOwner() {
                UserSubject subject = ctx.getSubject();
                return subject != null ? OAuthUtil.newOseePrincipal(subject) : null;
            }

            public OseePrincipal getClient() {
                UserSubject subject = ctx.getClientSubject();
                return subject != null ? OAuthUtil.newOseePrincipal(subject) : null;
            }

            public List<OseePermission> getPermissions() {
                List<OseePermission> perms = Collections.emptyList();
                List permissions = ctx.getPermissions();
                if (permissions != null && !permissions.isEmpty()) {
                    perms = new ArrayList<OseePermission>();
                    for (OAuthPermission permission : permissions) {
                        perms.add(OseeOAuthContextProvider.newPermission(permission));
                    }
                }
                return perms;
            }

            public String getTokenGrantType() {
                return ctx.getTokenGrantType();
            }

            public String getClientId() {
                return ctx.getClientId();
            }

            public String getTokenKey() {
                return ctx.getTokenKey();
            }

            public String getTokenAudience() {
                return ctx.getTokenAudience();
            }
        };
    }

    private static OseePermission newPermission(OAuthPermission permission) {
        Long id = new Long(permission.hashCode());
        return new OseePermissionImpl(id, permission);
    }

    private static final class OseePermissionImpl
    extends BaseIdentity<Long>
    implements OseePermission {
        private final OAuthPermission permission;

        public OseePermissionImpl(Long id, OAuthPermission permission) {
            super((Object)id);
            this.permission = permission;
        }

        public boolean isDefault() {
            return this.permission.isDefault();
        }

        public String getName() {
            return this.permission.getPermission();
        }

        public String getDescription() {
            return this.permission.getDescription();
        }

        public List<String> getUris() {
            return this.permission.getUris();
        }

        public List<String> getHttpVerbs() {
            return this.permission.getHttpVerbs();
        }
    }
}

