/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public final class WordMLNewLineMaker
extends Rule {
    private static final String TERMINATING_WP_XML = "\n</w:p>";
    private static final String DUMMY_PARAGRAPH_BEGINNING = "\n<w:p wsp:rsidR=\"01234567\" wsp:rsidRDefault=\"01234567\"><w:pPr><w:spacing w:before=\"48\" w:line=\"273\" w:line-rule=\"at-least\"/></w:pPr>";
    private final Pattern wordDocumentEndRegex = Pattern.compile(".*?</w:wordDocument>", 32);
    private final Pattern bodyRegex = Pattern.compile("<w:body>.*?</w:body>", 32);
    private final Pattern wxSubsectionRegex = Pattern.compile("<wx:sub-section>.*?</wx:sub-section>", 32);
    private final Pattern paragraphRegex = Pattern.compile("<w:p[ >].*?</w:p>", 32);
    private final Pattern wordRunRegex = Pattern.compile("<w:r[ >].*?</w:r>", 32);
    private final Pattern wordTextRegex = Pattern.compile("<w:t>(.*?)</w:t>", 32);
    private StringBuilder modifiedText = null;

    @Override
    public ChangeSet computeChanges(CharSequence entireFile) {
        this.modifiedText = new StringBuilder(entireFile.length() * 2);
        int lastBodySectionMatchEndIndex = -1;
        boolean foundSomething = false;
        Matcher bodySectionMatcher = this.bodyRegex.matcher(entireFile);
        if (bodySectionMatcher.find()) {
            Matcher wxSubSectionMatcher = this.wxSubsectionRegex.matcher(bodySectionMatcher.group());
            while (wxSubSectionMatcher.find()) {
                if (!foundSomething) {
                    this.writeToBuffer(entireFile.subSequence(0, bodySectionMatcher.start()));
                    this.writeToBuffer("\n<w:body>");
                }
                lastBodySectionMatchEndIndex = bodySectionMatcher.end();
                this.processWxSubSection(wxSubSectionMatcher.group());
                foundSomething = true;
            }
            if (foundSomething) {
                this.writeToBuffer("\n</w:body>");
            }
        }
        if (foundSomething && lastBodySectionMatchEndIndex != -1) {
            this.writeToBuffer(this.trimWordDocumentEnd(entireFile.subSequence(lastBodySectionMatchEndIndex, entireFile.length())));
        }
        return this.decideOnResultAndReturnIt(this.modifiedText, entireFile);
    }

    private CharSequence trimWordDocumentEnd(CharSequence endOfWordDocumentChunk) {
        Matcher endOfWordDocumentMatcher = this.wordDocumentEndRegex.matcher(endOfWordDocumentChunk);
        int chopOffAt = -1;
        if (endOfWordDocumentMatcher.find()) {
            chopOffAt = endOfWordDocumentMatcher.end();
        }
        if (chopOffAt != -1) {
            return endOfWordDocumentChunk.subSequence(0, chopOffAt);
        }
        return endOfWordDocumentChunk;
    }

    private ChangeSet decideOnResultAndReturnIt(StringBuilder modifiedFile, CharSequence entireFile) {
        boolean insertModified = this.modifiedText.length() > 0;
        this.setRuleWasApplicable(insertModified);
        return new ChangeSet(insertModified ? this.modifiedText : entireFile);
    }

    private void processWxSubSection(String wxSubSection) {
        Matcher paragraphMatcher = this.paragraphRegex.matcher(wxSubSection);
        boolean writtenPreBodySection = false;
        int lastParagraphMatchEndIndex = -1;
        while (paragraphMatcher.find()) {
            String paragraph = paragraphMatcher.group();
            if (!writtenPreBodySection) {
                this.writeToBuffer(wxSubSection.subSequence(0, paragraphMatcher.start()));
                writtenPreBodySection = true;
            }
            if (lastParagraphMatchEndIndex != -1) {
                this.writeToBuffer(wxSubSection.subSequence(lastParagraphMatchEndIndex, paragraphMatcher.start()));
            }
            this.processParagraph(paragraph);
            lastParagraphMatchEndIndex = paragraphMatcher.end();
        }
        this.writeToBuffer(wxSubSection.subSequence(lastParagraphMatchEndIndex, wxSubSection.length()));
    }

    private void processParagraph(String paragraph) {
        boolean outlineNumberAndNameDetected = false;
        Matcher wordRunMatcher = this.wordRunRegex.matcher(paragraph);
        boolean foundSplitArea = false;
        int indexOfWrPreceedingTheSplit = -1;
        while (wordRunMatcher.find()) {
            String singleWordRun = wordRunMatcher.group();
            boolean boldHint = singleWordRun.contains("<w:b/>");
            boolean underlineHint = singleWordRun.contains("<w:b-cs/>");
            if (boldHint && underlineHint) {
                outlineNumberAndNameDetected = true;
                indexOfWrPreceedingTheSplit = wordRunMatcher.end();
            }
            if (boldHint || underlineHint || !outlineNumberAndNameDetected) continue;
            foundSplitArea = true;
            break;
        }
        if (indexOfWrPreceedingTheSplit != -1 && foundSplitArea) {
            this.writeToBuffer(paragraph.subSequence(0, indexOfWrPreceedingTheSplit));
            this.writeToBuffer(TERMINATING_WP_XML);
            this.writeToBuffer(DUMMY_PARAGRAPH_BEGINNING);
            this.writeToBuffer(this.cleanUpWtFromChunk(paragraph.subSequence(indexOfWrPreceedingTheSplit, paragraph.length())));
        } else {
            this.writeToBuffer(paragraph);
        }
    }

    private StringBuilder cleanUpWtFromChunk(CharSequence chunk) {
        StringBuilder tempBuffer = new StringBuilder(chunk.length());
        Matcher wordRunMatcher = this.wordRunRegex.matcher(chunk);
        if (wordRunMatcher.find()) {
            tempBuffer.append(chunk.subSequence(0, wordRunMatcher.start()));
            Matcher wordTextMatcher = this.wordTextRegex.matcher(wordRunMatcher.group());
            if (wordTextMatcher.find()) {
                String text = wordTextMatcher.group(1);
                if (text.startsWith(".") && text.trim().length() > 1) {
                    tempBuffer.append("<w:r><w:t>");
                    tempBuffer.append(text.substring(1, text.length()));
                    tempBuffer.append("</w:t></w:r>");
                } else if (text.trim().length() > 1) {
                    tempBuffer.append("<w:r><w:t>");
                    tempBuffer.append(text);
                    tempBuffer.append("</w:t></w:r>");
                }
                tempBuffer.append(chunk.subSequence(wordRunMatcher.end(), chunk.length()));
            }
        }
        return tempBuffer;
    }

    private void writeToBuffer(CharSequence subSequence) {
        if (this.modifiedText != null) {
            this.modifiedText.append(subSequence);
        } else {
            System.out.println("StringBuilder modifiedText is null! Ignoring write...");
        }
    }
}

