/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.ide.actions.AccessControlAction;
import org.eclipse.osee.ats.ide.actions.CreateActionFromTaskAction;
import org.eclipse.osee.ats.ide.actions.DeletePurgeAtsArtifactsAction;
import org.eclipse.osee.ats.ide.actions.DirtyReportAction;
import org.eclipse.osee.ats.ide.actions.EditActionableItemsAction;
import org.eclipse.osee.ats.ide.actions.EmailActionAction;
import org.eclipse.osee.ats.ide.actions.FavoriteAction;
import org.eclipse.osee.ats.ide.actions.ModifyActionableItemAction;
import org.eclipse.osee.ats.ide.actions.MoveWorkflowWorkingBranchToWorkflowAction;
import org.eclipse.osee.ats.ide.actions.OpenInArtifactEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenInAtsWorldAction;
import org.eclipse.osee.ats.ide.actions.OpenInSkyWalkerAction;
import org.eclipse.osee.ats.ide.actions.OpenParentAction;
import org.eclipse.osee.ats.ide.actions.RefreshDirtyAction;
import org.eclipse.osee.ats.ide.actions.ResourceHistoryAction;
import org.eclipse.osee.ats.ide.actions.ShowBranchChangeDataAction;
import org.eclipse.osee.ats.ide.actions.ShowWorkDefinitionAction;
import org.eclipse.osee.ats.ide.actions.SubscribedAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.IWfeOperationsSection;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfeReloadAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.operation.MoveTeamWorkflowsAction;
import org.eclipse.osee.ats.ide.workflow.duplicate.DuplicateWorkflowAction;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonViaAction;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeOperationsSection
extends SectionPart {
    protected final WorkflowEditor editor;
    private static List<IWfeOperationsSection> operationsSectionProviders;
    private boolean sectionCreated = false;

    public WfeOperationsSection(WorkflowEditor editor, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style | 2 | 0x100);
        this.editor = editor;
        this.registerAdvancedSectionsFromExtensionPoints();
    }

    private synchronized void registerAdvancedSectionsFromExtensionPoints() {
        if (operationsSectionProviders == null) {
            operationsSectionProviders = new ArrayList<IWfeOperationsSection>();
            ExtensionDefinedObjects extensions = new ExtensionDefinedObjects("org.eclipse.osee.ats.ide.AtsAdvancedOperationAction", "AtsAdvancedOperationAction", "classname", true);
            for (IWfeOperationsSection item : extensions.getObjects()) {
                operationsSectionProviders.add(item);
            }
        }
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        final FormToolkit toolkit = form.getToolkit();
        final Section section = this.getSection();
        section.setText("Operations");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                WfeOperationsSection.this.createSection(section, toolkit);
            }
        });
    }

    private synchronized void createSection(Section section, FormToolkit toolkit) {
        if (this.sectionCreated) {
            return;
        }
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)new GridLayout(3, false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createImpactsSection(sectionBody, toolkit);
        this.createViewsEditorsSection(sectionBody, toolkit);
        this.createNotificationsSection(sectionBody, toolkit);
        this.createAdvancedSection(sectionBody, toolkit);
        this.createAdminSection(sectionBody, toolkit);
        section.setClient((Control)sectionBody);
        toolkit.paintBordersFor((Composite)section);
        this.sectionCreated = true;
    }

    private void createImpactsSection(Composite parent, FormToolkit toolkit) {
        if (!this.editor.getWorkItem().isTeamWorkflow() && !this.editor.getWorkItem().isTask()) {
            return;
        }
        Section section = toolkit.createSection(parent, 256);
        section.setText("Impacts and Workflows");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.editor.getWorkItem().isTeamWorkflow()) {
            new XButtonViaAction((Action)new EditActionableItemsAction((TeamWorkFlowArtifact)this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new DuplicateWorkflowAction(Collections.singleton((TeamWorkFlowArtifact)this.editor.getWorkItem()))).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new ModifyActionableItemAction((TeamWorkFlowArtifact)this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new AccessControlAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
        }
        if (this.editor.getWorkItem().isTask()) {
            new XButtonViaAction((Action)new CreateActionFromTaskAction(Collections.singleton((TaskArtifact)this.editor.getWorkItem()))).createWidgets(sectionBody, 2);
        }
        section.setClient((Control)sectionBody);
    }

    private void createAdvancedSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Advanced");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.editor.getWorkItem().isTeamWorkflow()) {
            new XButtonViaAction((Action)new DirtyReportAction(this.editor)).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new WfeReloadAction(this.editor.getWorkItem(), this.editor)).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new MoveTeamWorkflowsAction()).createWidgets(sectionBody, 2);
        }
        for (IWfeOperationsSection operation : operationsSectionProviders) {
            operation.createAdvancedSection(this.editor, sectionBody, toolkit);
        }
        section.setClient((Control)sectionBody);
    }

    private void createAdminSection(Composite parent, FormToolkit toolkit) {
        if (!AtsApiService.get().getUserService().isAtsAdmin()) {
            return;
        }
        Section section = toolkit.createSection(parent, 256);
        section.setText("Admin");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        new XButtonViaAction((Action)new RefreshDirtyAction((IDirtiableEditor)this.editor)).createWidgets(sectionBody, 2);
        new XButtonViaAction((Action)new DeletePurgeAtsArtifactsAction(this.editor, false)).createWidgets(sectionBody, 2);
        if (ShowBranchChangeDataAction.isApplicable(this.editor.getWorkItem())) {
            new XButtonViaAction((Action)new ShowBranchChangeDataAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
        }
        new XButtonViaAction((Action)new MoveWorkflowWorkingBranchToWorkflowAction(this.editor, AtsApiService.get())).createWidgets(sectionBody, 2);
        for (IWfeOperationsSection operation : operationsSectionProviders) {
            operation.createAdminSection(this.editor, sectionBody, toolkit);
        }
        section.setClient((Control)sectionBody);
    }

    private void createViewsEditorsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Views and Editors");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            new XButtonViaAction((Action)new OpenInAtsWorldAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new OpenInSkyWalkerAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new ResourceHistoryAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            if (this.editor.getWorkItem().getParentAWA() != null) {
                new XButtonViaAction((Action)new OpenParentAction(this.editor.getWorkItem())).createWidgets(sectionBody, 2);
            }
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                new XButtonViaAction((Action)new OpenInArtifactEditorAction(this.editor)).createWidgets(sectionBody, 2);
            }
            new XButtonViaAction((Action)new ShowWorkDefinitionAction()).createWidgets(sectionBody, 2);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        section.setClient((Control)sectionBody);
    }

    private void createNotificationsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Notifications and Favorites");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite sectionBody = toolkit.createComposite((Composite)section, 0);
        sectionBody.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        sectionBody.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            new XButtonViaAction((Action)new SubscribedAction(this.editor)).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new FavoriteAction(this.editor)).createWidgets(sectionBody, 2);
            new XButtonViaAction((Action)new EmailActionAction(this.editor)).createWidgets(sectionBody, 2);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        section.setClient((Control)sectionBody);
    }
}

