/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboWithTextAndComboWithText;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class OperationalImpactWithWorkaroundXWidget
extends XComboWithTextAndComboWithText
implements ArtifactWidget {
    TeamWorkFlowArtifact teamArt;

    public OperationalImpactWithWorkaroundXWidget() {
        super("Operational Impact", "Operational Impact Description", new String[]{"Yes", "No"}, "Yes", true, true, "Workaround", "Workaround Desription", new String[]{"Yes", "No"}, "Yes", true);
    }

    public Artifact getArtifact() {
        return this.teamArt;
    }

    public void saveToArtifact() {
        String impact = this.get();
        if (impact == null || impact.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpact);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, impact);
        }
        String desc = this.getDescStr();
        if (desc == null || desc.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, desc);
        }
        String workaroundImpact = this.getWorkaroundImpact();
        if (workaroundImpact == null || workaroundImpact.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaround);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaround, workaroundImpact);
        }
        String workaroundDesc = this.getWorkaroundDescStr();
        if (workaroundDesc == null || workaroundDesc.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaroundDescription);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaroundDescription, workaroundDesc);
        }
    }

    public void revert() {
        try {
            super.set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, ""));
            if (this.getText() != null) {
                this.getText().set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, ""));
            }
            if (this.getComboWithText() != null) {
                this.getComboWithText().set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaround, ""));
                if (this.getComboWithText().getText() != null) {
                    this.getComboWithText().getText().set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaroundDescription, ""));
                }
                this.getComboWithText().refresh();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public Result isDirty() {
        if (!this.get().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpact.toString());
        }
        if (!this.getDescStr().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpactDescription.toString());
        }
        if (!this.getWorkaroundImpact().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaround, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpactWorkaround.toString());
        }
        if (!this.getWorkaroundDescStr().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaroundDescription, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpactWorkaroundDescription.toString());
        }
        return Result.FalseResult;
    }

    private String getDescStr() {
        if (this.getText() == null || !Widgets.isAccessible((Widget)this.getText().getStyledText())) {
            return "";
        }
        return this.getText().get();
    }

    private String getWorkaroundImpact() {
        if (this.getComboWithText() == null) {
            return "";
        }
        return this.getComboWithText().get();
    }

    private String getWorkaroundDescStr() {
        if (this.getComboWithText() == null || this.getComboWithText().getText() == null || !Widgets.isAccessible((Widget)this.getComboWithText().getText().getStyledText())) {
            return "";
        }
        return this.getComboWithText().getText().get();
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.teamArt = (TeamWorkFlowArtifact)artifact;
        }
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        this.revert();
    }

    protected int getTextHeightHint() {
        if (this.getDescStr().equals("")) {
            return 30;
        }
        return super.getTextHeightHint();
    }
}

