/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class SprintItems {
    private final Collection<? extends Artifact> workItemArts;
    private boolean commonSelectedSprint;
    private boolean noBacklogDetected;
    private boolean multipleBacklogsDetected;
    private Artifact commonBacklog;
    private Set<ArtifactToken> multipleSprints;

    public SprintItems(Collection<? extends Artifact> workItemArts) {
        this.workItemArts = workItemArts;
        this.validate();
    }

    public void validate() {
        this.commonBacklog = null;
        this.multipleSprints = new HashSet<ArtifactToken>();
        this.commonSelectedSprint = false;
        this.noBacklogDetected = false;
        this.multipleBacklogsDetected = false;
        for (Artifact artifact : this.workItemArts) {
            if (!(artifact instanceof IAtsWorkItem)) continue;
            IAtsWorkItem workItem = (IAtsWorkItem)artifact;
            try {
                ArtifactToken backlogArt = AtsApiService.get().getRelationResolver().getRelatedOrNull((IAtsObject)workItem, AtsRelationTypes.AgileBacklog_AgileBacklog);
                Artifact relatedBacklogArt = null;
                if (backlogArt != null && backlogArt.isValid()) {
                    relatedBacklogArt = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)backlogArt);
                }
                if (relatedBacklogArt == null) {
                    this.noBacklogDetected = true;
                } else if (this.commonBacklog == null) {
                    this.commonBacklog = relatedBacklogArt;
                } else if (this.commonBacklog.notEqual((Id)relatedBacklogArt)) {
                    this.multipleBacklogsDetected = true;
                }
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {
                this.noBacklogDetected = true;
            }
            this.multipleSprints.addAll(AtsApiService.get().getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.AgileSprintToItem_AgileSprint));
            boolean bl = this.commonSelectedSprint = this.multipleSprints.size() <= 1;
        }
    }

    public boolean isCommonSelectedSprint() {
        return this.commonSelectedSprint;
    }

    public boolean isNoBacklogDetected() {
        return this.noBacklogDetected;
    }

    public boolean isMultipleBacklogsDetected() {
        return this.multipleBacklogsDetected;
    }

    public IAgileBacklog getCommonBacklog() {
        IAgileBacklog backlog = null;
        if (this.commonBacklog != null) {
            backlog = AtsApiService.get().getWorkItemService().getAgileBacklog((ArtifactToken)this.commonBacklog);
        }
        return backlog;
    }

    public Set<IAgileSprint> getMultipleSprints() {
        HashSet<IAgileSprint> sprints = new HashSet<IAgileSprint>();
        for (ArtifactToken art : this.multipleSprints) {
            sprints.add(AtsApiService.get().getWorkItemService().getAgileSprint(art));
        }
        return sprints;
    }
}

