/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.parser;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.ote.define.parser.BaseOutfileParser;
import org.eclipse.osee.ote.define.parser.CollectionParser;
import org.eclipse.osee.ote.define.parser.IDataListener;
import org.eclipse.osee.ote.define.parser.SaxChunkCollector;
import org.eclipse.osee.ote.define.parser.handlers.ConfigHandler;
import org.eclipse.osee.ote.define.parser.handlers.CurrentProcessorHandler;
import org.eclipse.osee.ote.define.parser.handlers.DemoInfoHandler;
import org.eclipse.osee.ote.define.parser.handlers.ElapsedTimeHandler;
import org.eclipse.osee.ote.define.parser.handlers.ExecutionStatusHandler;
import org.eclipse.osee.ote.define.parser.handlers.RuntimeVersionsHandler;
import org.eclipse.osee.ote.define.parser.handlers.SystemInfoHandler;
import org.eclipse.osee.ote.define.parser.handlers.TestPointResultsHandler;
import org.eclipse.osee.ote.define.parser.handlers.VersionInformationHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OteOutfileParser
extends BaseOutfileParser {
    private final ArrayList<SaxChunkCollector> collectors = new ArrayList();

    public OteOutfileParser() {
        this.collectors.add(new SaxChunkCollector(new ConfigHandler(), "Config"));
        this.collectors.add(new SaxChunkCollector(new RuntimeVersionsHandler(), "RuntimeVersions"));
        this.collectors.add(new SaxChunkCollector(new SystemInfoHandler(), "SystemInfo"));
        this.collectors.add(new SaxChunkCollector(new CurrentProcessorHandler(), "CurrentProcessor"));
        this.collectors.add(new SaxChunkCollector(new ExecutionStatusHandler(), "ExecutionStatus"));
        this.collectors.add(new SaxChunkCollector(new ElapsedTimeHandler(), "TimeSummary"));
        this.collectors.add(new SaxChunkCollector(new VersionInformationHandler(), "Version"));
        this.collectors.add(new SaxChunkCollector(new TestPointResultsHandler(), "TestPointResults"));
        this.collectors.add(new SaxChunkCollector(new DemoInfoHandler(), "Qualification"));
    }

    @Override
    public void registerListener(IDataListener listener) {
        super.registerListener(listener);
        for (SaxChunkCollector collector : this.collectors) {
            collector.getHandler().addListener(listener);
        }
    }

    @Override
    public void deregisterListener(IDataListener listener) {
        super.deregisterListener(listener);
        for (SaxChunkCollector collector : this.collectors) {
            collector.getHandler().removeListener(listener);
        }
    }

    @Override
    protected void doParse(IProgressMonitor monitor, String fileName, InputStream inputStream) throws Exception {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        CollectionParser handler = new CollectionParser(this.collectors);
        xmlReader.setContentHandler((ContentHandler)((Object)handler));
        xmlReader.parse(new InputSource(inputStream));
    }

    @Override
    public boolean isValidParser(URL fileToParse) {
        boolean result = false;
        if (fileToParse != null) {
            String extension = Lib.getExtension((String)fileToParse.getFile());
            result = extension != null && extension.contains("tmo");
        }
        return result;
    }
}

