/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.icteam.reqif.dialogs.ExportReqIfDialog;
import org.eclipse.osee.icteam.reqif.export.ReqIfCreateResoure;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportReqIfHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            try {
                Object firstElement;
                IStructuredSelection structSel = (IStructuredSelection)currentSelection;
                if (!structSel.isEmpty() && (firstElement = structSel.getFirstElement()) instanceof Artifact) {
                    Artifact parentArtifact = (Artifact)firstElement;
                    List<Artifact> requirmentChildren = this.getRequirmentChildren(parentArtifact);
                    ExportReqIfDialog dialog = new ExportReqIfDialog(Displays.getActiveShell());
                    int open = dialog.open();
                    if (open == 0) {
                        ReqIfCreateResoure createResource = new ReqIfCreateResoure();
                        createResource.createReqIfResource(String.valueOf(dialog.getDirName()) + "/" + dialog.getFileName(), requirmentChildren);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<Artifact> getRequirmentChildren(Artifact parentArtifact) throws OseeCoreException {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        List children = parentArtifact.getChildren();
        for (Artifact artifact : children) {
            if (!artifact.getArtifactType().getName().equalsIgnoreCase(AtsArtifactTypes.RequirementDocument.getName())) continue;
            List children2 = artifact.getChildren();
            for (Artifact artifact2 : children2) {
                if (!artifact2.getArtifactType().getName().equalsIgnoreCase(AtsArtifactTypes.Software_ReQ.getName())) continue;
                artifactList.add(artifact2);
            }
        }
        return artifactList;
    }
}

