/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class ReqIFUtil {
    public static GregorianCalendar getGregorianCalendarNow() throws DatatypeConfigurationException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        return calendar;
    }

    public static Artifact createModuleReqFolder(Branch projectBranch, Artifact parent, String moduleName) throws OseeCoreException {
        SkynetTransaction transaction1 = TransactionManager.createTransaction((BranchId)projectBranch, (String)String.format("Created new %s \"%s\" in artifact explorer", "Project Module", moduleName));
        Artifact newChildArt = parent.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.ProjectModule, moduleName);
        parent.persist(transaction1);
        transaction1.execute();
        return newChildArt;
    }

    public static File changeExtension(String fileName) throws IOException {
        int length;
        String newFileName = fileName.replace(".xml", ".reqif");
        File reqifFile = new File(newFileName);
        File oldFile = new File(fileName);
        FileInputStream inStream = new FileInputStream(oldFile);
        FileOutputStream outStream = new FileOutputStream(reqifFile);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
            ((OutputStream)outStream).write(buffer, 0, length);
        }
        ((InputStream)inStream).close();
        ((OutputStream)outStream).close();
        return reqifFile;
    }
}

