/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.tabledataframework;

import java.rmi.activation.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.model.tabledataframework.Column;
import org.eclipse.osee.framework.core.model.tabledataframework.KeyColumn;
import org.eclipse.osee.framework.core.model.tabledataframework.TableData;
import org.eclipse.osee.framework.logging.OseeLog;

public class TableDataImpl
implements TableData {
    private final List<Column> columns = new ArrayList<Column>();
    private final List<KeyColumn> keyColumns = new ArrayList<KeyColumn>();
    private boolean firstRun = true;

    protected void addColumn(Column column) {
        this.columns.add(column);
    }

    protected void addKeyColumn(KeyColumn keyColumn) {
        this.keyColumns.add(keyColumn);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Collection<Object> getHeaderStrings() {
        ArrayList<Object> headerStrings = new ArrayList<Object>();
        for (Column col : this.columns) {
            if (!col.isVisible()) continue;
            headerStrings.add(col.getHeaderString());
        }
        return headerStrings;
    }

    @Override
    public Iterator<Collection<Object>> iterator() {
        return new TableDataIterator();
    }

    @Override
    public int getRowCount() {
        int manyRows = 1;
        for (KeyColumn keyColumn : this.keyColumns) {
            List<Object> allObjs = keyColumn.getAll();
            manyRows *= allObjs.size();
        }
        return manyRows;
    }

    @Override
    public String getName() {
        return "";
    }

    protected boolean validateRow(Collection<Object> rowData) {
        return true;
    }

    protected boolean validateRowUseOnlyKeyColums() {
        return true;
    }

    protected void beforeRow() {
    }

    protected void afterRow() {
    }

    protected void handleExceptions(Exception ex) {
    }

    public class TableDataIterator
    implements Iterator<Collection<Object>> {
        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            for (KeyColumn keyColumn : TableDataImpl.this.keyColumns) {
                if (!keyColumn.hasNext()) continue;
                hasNext = true;
                break;
            }
            return hasNext;
        }

        @Override
        public Collection<Object> next() {
            ArrayList<Object> cols = new ArrayList<Object>();
            try {
                TableDataImpl.this.beforeRow();
                boolean isRowValid = false;
                while (this.hasNext() && !isRowValid) {
                    KeyColumn keyColumn;
                    int keyColIndex;
                    if (TableDataImpl.this.firstRun) {
                        keyColIndex = 0;
                        while (keyColIndex < TableDataImpl.this.keyColumns.size() - 1) {
                            keyColumn = TableDataImpl.this.keyColumns.get(keyColIndex);
                            keyColumn.next();
                            ++keyColIndex;
                        }
                        TableDataImpl.this.firstRun = false;
                    }
                    keyColIndex = TableDataImpl.this.keyColumns.size() - 1;
                    while (keyColIndex >= 0) {
                        keyColumn = TableDataImpl.this.keyColumns.get(keyColIndex);
                        if (keyColumn.hasNext()) {
                            keyColumn.next();
                            break;
                        }
                        keyColumn.reset();
                        keyColumn.next();
                        --keyColIndex;
                    }
                    boolean areKeyColsValid = TableDataImpl.this.validateRowUseOnlyKeyColums();
                    if (!areKeyColsValid) continue;
                    for (Column col : TableDataImpl.this.columns) {
                        if (!col.isVisible()) continue;
                        cols.add(col.getData());
                    }
                    isRowValid = TableDataImpl.this.validateRow(cols);
                }
                TableDataImpl.this.afterRow();
            }
            catch (Exception ex) {
                TableDataImpl.this.handleExceptions(ex);
                cols.add(ex.toString());
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            return cols;
        }

        @Override
        public void remove() {
        }
    }
}

