/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.event;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.IBasicGuidRelation;

public class DefaultBasicIdRelation
implements IBasicGuidRelation {
    DefaultBasicGuidArtifact artA;
    DefaultBasicGuidArtifact artB;
    BranchId branch;
    Long relTypeUuid;
    GammaId gammaId;
    Long relationId;

    public DefaultBasicIdRelation(BranchId branch, Long relTypeUuid, Long relationId, GammaId gammaId, DefaultBasicGuidArtifact artA, DefaultBasicGuidArtifact artB) {
        this.branch = branch;
        this.relTypeUuid = relTypeUuid;
        this.relationId = relationId;
        this.gammaId = gammaId;
        this.artA = artA;
        this.artB = artB;
    }

    @Override
    public DefaultBasicGuidArtifact getArtA() {
        return this.artA;
    }

    @Override
    public DefaultBasicGuidArtifact getArtB() {
        return this.artB;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    @Override
    public GammaId getGammaId() {
        return this.gammaId;
    }

    @Override
    public Long getRelTypeGuid() {
        return this.relTypeUuid;
    }

    public void setArtA(DefaultBasicGuidArtifact artA) {
        this.artA = artA;
    }

    public void setArtB(DefaultBasicGuidArtifact artB) {
        this.artB = artB;
    }

    public void setBranchUuid(BranchId branch) {
        this.branch = branch;
    }

    public void setRelTypeGuid(Long relTypeGuid) {
        this.relTypeUuid = relTypeGuid;
    }

    public void setGammaId(GammaId gammaId) {
        this.gammaId = gammaId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artA == null ? 0 : this.artA.hashCode());
        result = 31 * result + (this.artB == null ? 0 : this.artB.hashCode());
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + this.gammaId.hashCode();
        result = 31 * result + (this.relTypeUuid == null ? 0 : this.relTypeUuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IBasicGuidRelation other = (IBasicGuidRelation)obj;
        if (this.artA == null ? other.getArtA() != null : !this.artA.equals((Object)other.getArtA())) {
            return false;
        }
        if (this.artB == null ? other.getArtB() != null : !this.artB.equals((Object)other.getArtB())) {
            return false;
        }
        if (!this.isOnSameBranch(other)) {
            return false;
        }
        if (this.gammaId != other.getGammaId()) {
            return false;
        }
        return !(this.relTypeUuid == null ? other.getRelTypeGuid() != null : !this.relTypeUuid.equals(other.getRelTypeGuid()));
    }

    public Long getRelationId() {
        return this.relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public boolean is(RelationTypeToken ... relationTypes) {
        RelationTypeToken[] relationTypeTokenArray = relationTypes;
        int n = relationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationTypeToken relType = relationTypeTokenArray[n2];
            if (relType.equals(this.getRelTypeGuid())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

