/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.relation.order.IRelationSorter;
import org.eclipse.osee.framework.skynet.core.relation.sorters.LexicographicalRelationSorter;
import org.eclipse.osee.framework.skynet.core.relation.sorters.UnorderedRelationSorter;
import org.eclipse.osee.framework.skynet.core.relation.sorters.UserDefinedRelationSorter;

public class RelationSorterProvider {
    private final Map<RelationSorter, IRelationSorter> orderMap = new ConcurrentHashMap<RelationSorter, IRelationSorter>();

    public RelationSorterProvider() {
        this.registerOrderType(new LexicographicalRelationSorter(LexicographicalRelationSorter.SortMode.ASCENDING));
        this.registerOrderType(new LexicographicalRelationSorter(LexicographicalRelationSorter.SortMode.DESCENDING));
        this.registerOrderType(new UnorderedRelationSorter());
        this.registerOrderType(new UserDefinedRelationSorter());
    }

    private void registerOrderType(IRelationSorter order) {
        this.orderMap.put(order.getSorterId(), order);
    }

    public IRelationSorter getRelationOrder(RelationSorter sorterId) {
        if (sorterId.equals((Object)RelationSorter.PREEXISTING)) {
            throw new OseeArgumentException("No sorted is defined for preexisting (nor should there be).", new Object[0]);
        }
        IRelationSorter order = this.orderMap.get(sorterId);
        if (order == null) {
            throw new OseeCoreException("Unable to locate RelationSorter[%s].", new Object[]{sorterId});
        }
        return order;
    }

    public Collection<IRelationSorter> getSorters() {
        return this.orderMap.values();
    }

    public List<RelationSorter> getAllRelationOrderIds() {
        Collection<IRelationSorter> relationOrder = this.orderMap.values();
        ArrayList<RelationSorter> ids = new ArrayList<RelationSorter>();
        for (IRelationSorter order : relationOrder) {
            ids.add(order.getSorterId());
        }
        Collections.sort(ids);
        return ids;
    }
}

