/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.messaging.event.res.AttributeEventModificationType;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemotePersistEvent1;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.ChangeArtifactType;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventChangeTypeBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventModifiedBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerRemote;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class ArtifactRemoteEventHandler
implements EventHandlerRemote<RemotePersistEvent1> {
    private final OrcsTokenService tokenService;

    public ArtifactRemoteEventHandler(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public void handle(Transport transport, Sender sender, RemotePersistEvent1 remoteEvent) {
        RemotePersistEvent1 event1 = remoteEvent;
        ArtifactEvent transEvent = FrameworkEventUtil.getPersistEvent(event1, this.tokenService);
        this.updateArtifacts(sender, transEvent.getArtifacts(), remoteEvent.getTransaction());
        this.updateRelations(sender, transEvent.getRelations());
        transport.send(sender, transEvent);
    }

    private void updateArtifacts(Sender sender, Collection<EventBasicGuidArtifact> artifacts, TransactionToken transactionId) {
        for (EventBasicGuidArtifact guidArt : artifacts) {
            EventUtil.eventLog((String)String.format("REM: updateArtifact -> [%s]", new Object[]{guidArt}), (Object[])new Object[0]);
            EventModType eventModType = guidArt.getModType();
            switch (eventModType) {
                case Added: {
                    break;
                }
                case Modified: {
                    this.updateModifiedArtifact((EventModifiedBasicGuidArtifact)guidArt, transactionId);
                    break;
                }
                case ChangeType: {
                    ChangeArtifactType.handleRemoteChangeType((EventChangeTypeBasicGuidArtifact)guidArt);
                    break;
                }
                case Deleted: 
                case Purged: {
                    this.updateDeletedArtifact(guidArt);
                    break;
                }
                default: {
                    EventUtil.eventLog((String)String.format("REM: updateArtifacts - Unhandled mod type [%s]", new Object[]{guidArt.getModType()}), (Object[])new Object[0]);
                }
            }
        }
    }

    private void updateDeletedArtifact(DefaultBasicGuidArtifact guidArt) {
        try {
            Artifact artifact = ArtifactCache.getActive(guidArt);
            if (artifact != null && !artifact.isHistorical()) {
                artifact.internalSetDeletedFromRemoteEvent();
            }
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: updateDeletedArtifact", (Throwable)ex);
        }
    }

    private void updateModifiedArtifact(EventModifiedBasicGuidArtifact guidArt, TransactionToken transactionId) {
        try {
            Artifact artifact = ArtifactCache.getActive(guidArt);
            if (artifact != null && !artifact.isHistorical()) {
                artifact.setTransactionId(TransactionManager.getTransaction((TransactionId)transactionId));
                for (AttributeChange attrChange : guidArt.getAttributeChanges()) {
                    if (OseeEventManager.getPreferences().isEnableRemoteEventLoopback()) continue;
                    ModificationType modificationType = AttributeEventModificationType.getType((String)attrChange.getModTypeGuid()).getModificationType();
                    AttributeTypeGeneric attributeType = this.tokenService.getAttributeType(attrChange.getAttrTypeGuid());
                    try {
                        Attribute<?> attribute = artifact.getAttributeById(attrChange.getAttributeId(), true);
                        if (attribute != null) {
                            if (attribute.isDirty()) {
                                EventUtil.eventLog((String)String.format("%s's attribute %d [/n%s/n] has been overwritten.", artifact.getSafeName(), attribute.getId(), attribute.toString()), (Object[])new Object[0]);
                            }
                            try {
                                if (modificationType == null) {
                                    EventUtil.eventLog((String)String.format("REM: updateModifiedArtifact - Can't get mod type for %s's attribute %d.", artifact.getArtifactTypeName(), attrChange.getAttributeId()), (Object[])new Object[0]);
                                    continue;
                                }
                                if (modificationType.isDeleted()) {
                                    attribute.internalSetModType(modificationType, false, false);
                                } else {
                                    attribute.getAttributeDataProvider().loadData(attrChange.getDataArray());
                                }
                                attribute.setNotDirty();
                                attribute.internalSetGammaId(attrChange.getGammaId());
                            }
                            catch (OseeCoreException ex) {
                                EventUtil.eventLog((String)String.format("REM: Exception updating %s's attribute %d [/n%s/n].", artifact.getSafeName(), attribute.getId(), attribute.toString()), (Throwable)ex);
                            }
                            continue;
                        }
                        if (modificationType == null) {
                            EventUtil.eventLog((String)String.format("REM: Can't get mod type for %s's attribute %d.", artifact.getArtifactTypeName(), attrChange.getAttributeId()), (Object[])new Object[0]);
                            continue;
                        }
                        artifact.internalInitializeAttribute((AttributeTypeToken)attributeType, attrChange.getAttributeId(), attrChange.getGammaId(), modificationType, attrChange.getApplicabilityId(), false, attrChange.getDataArray());
                    }
                    catch (OseeCoreException ex) {
                        EventUtil.eventLog((String)String.format("REM: Exception updating %s's attribute change for attributeTypeId %d.", artifact.getSafeName(), attributeType.getId()), (Throwable)ex);
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: updateModifiedArtifact", (Throwable)ex);
        }
    }

    private void updateRelations(Sender sender, Collection<EventBasicGuidRelation> relations) {
        block8: for (EventBasicGuidRelation guidArt : relations) {
            try {
                boolean bArtifactLoaded;
                EventUtil.eventLog((String)String.format("REM: updateRelation -> [%s]", new Object[]{guidArt}), (Object[])new Object[0]);
                RelationTypeToken relationType = this.tokenService.getRelationType(guidArt.getRelTypeGuid());
                Artifact aArtifact = ArtifactCache.getActive(guidArt.getArtA());
                Artifact bArtifact = ArtifactCache.getActive(guidArt.getArtB());
                if (aArtifact == null && bArtifact == null) continue;
                boolean aArtifactLoaded = aArtifact != null;
                boolean bl = bArtifactLoaded = bArtifact != null;
                if (!aArtifactLoaded && !bArtifactLoaded) continue;
                BranchToken branch = BranchManager.getBranchToken(guidArt.getArtA().getBranch());
                ArtifactToken artifactIdA = ArtifactToken.valueOf((long)guidArt.getArtAId(), (BranchId)branch);
                ArtifactToken artifactIdB = ArtifactToken.valueOf((long)guidArt.getArtBId(), (BranchId)branch);
                RelationLink relation = RelationManager.getLoadedRelationById(RelationId.valueOf((Long)guidArt.getRelationId()), (ArtifactId)artifactIdA, (ArtifactId)artifactIdB, branch);
                RelationEventType eventType = guidArt.getModType();
                switch (eventType) {
                    case Added: {
                        if (relation != null && relation.getModificationType() != ModificationType.DELETED && relation.getModificationType() != ModificationType.ARTIFACT_DELETED) continue block8;
                        ApplicabilityId appId = relation == null ? ApplicabilityId.BASE : relation.getApplicabilityId();
                        relation = RelationManager.getOrCreate(artifactIdA, artifactIdB, relationType, RelationId.valueOf((Long)guidArt.getRelationId()), guidArt.getGammaId(), guidArt.getRationale(), ModificationType.NEW, appId);
                        break;
                    }
                    case ModifiedRationale: {
                        if (relation == null) continue block8;
                        relation.internalSetRationale(guidArt.getRationale());
                        relation.setNotDirty();
                        break;
                    }
                    case Deleted: 
                    case Purged: {
                        if (relation == null) continue block8;
                        relation.internalRemoteEventDelete();
                        break;
                    }
                    case Undeleted: {
                        if (relation == null) continue block8;
                        relation.undelete();
                        relation.setNotDirty();
                        break;
                    }
                    default: {
                        EventUtil.eventLog((String)String.format("REM: updateRelations - Unhandled mod type [%s]", new Object[]{eventType}), (Object[])new Object[0]);
                        break;
                    }
                }
            }
            catch (OseeCoreException ex) {
                EventUtil.eventLog((String)"REM: updateRelations", (Throwable)ex);
            }
        }
    }
}

