/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.jdk.core.type.NamedIdDescription;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public abstract class ComputedCharacteristic<T>
extends NamedIdDescription
implements ComputedCharacteristicToken<T> {
    private final TaggerTypeToken taggerType;
    private final NamespaceToken namespace;
    protected final List<AttributeTypeGeneric<T>> typesToCompute;
    protected final Set<DisplayHint> displayHints;

    public ComputedCharacteristic(Long id, String name, TaggerTypeToken taggerType, NamespaceToken namespace, String description, List<AttributeTypeGeneric<T>> typesToCompute, Set<DisplayHint> displayHints) {
        super(id, name, description);
        this.namespace = namespace;
        this.taggerType = taggerType;
        this.typesToCompute = typesToCompute;
        this.displayHints = displayHints;
    }

    public ComputedCharacteristic(Long id, String name, TaggerTypeToken taggerType, NamespaceToken namespace, String description, List<AttributeTypeGeneric<T>> typesToCompute) {
        this(id, name, taggerType, namespace, description, typesToCompute, java.util.Collections.emptySet());
    }

    public ComputedCharacteristic(Long id, String name, TaggerTypeToken taggerType, NamespaceToken namespace, String description, List<AttributeTypeGeneric<T>> typesToCompute, DisplayHint ... displayHints) {
        this(id, name, taggerType, namespace, description, typesToCompute, Collections.asHashSet((Object[])displayHints));
    }

    @Override
    public List<AttributeTypeGeneric<T>> getAttributeTypesToCompute() {
        return this.typesToCompute;
    }

    @Override
    public String getMediaType() {
        return "text/plain";
    }

    @Override
    public TaggerTypeToken getTaggerType() {
        return this.taggerType;
    }

    @Override
    public NamespaceToken getNamespace() {
        return this.namespace;
    }

    @Override
    public Set<DisplayHint> getDisplayHints() {
        return this.displayHints;
    }

    protected boolean exactlyTwoValues(ArtifactTypeToken artifactType) {
        if (this.typesToCompute.size() != 2) {
            return false;
        }
        for (AttributeTypeGeneric<T> attributeType : this.typesToCompute) {
            if (artifactType.getMax(attributeType) <= 1) continue;
            return false;
        }
        return true;
    }

    protected boolean atLeastTwoValues(ArtifactTypeToken artifactType) {
        if (this.typesToCompute.isEmpty()) {
            return false;
        }
        for (AttributeTypeGeneric<T> attributeType : this.typesToCompute) {
            if (this.typesToCompute.size() != 1 || artifactType.getMax(attributeType) != 1) continue;
            return false;
        }
        return true;
    }
}

