/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBranchEvent1;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerRemote;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class BranchRemoteEventHandler
implements EventHandlerRemote<RemoteBranchEvent1> {
    @Override
    public void handle(Transport transport, Sender sender, RemoteBranchEvent1 remoteEvent) {
        BranchEvent branchEvent = FrameworkEventUtil.getBranchEvent(remoteEvent);
        this.updateBranches(sender, branchEvent);
        transport.send(sender, branchEvent);
    }

    private void updateBranches(Sender sender, BranchEvent branchEvent) {
        BranchEventType eventType = branchEvent.getEventType();
        BranchId branchId = branchEvent.getSourceBranch();
        try {
            if (BranchManager.isLoaded()) {
                if (BranchManager.branchExists(branchId)) {
                    Branch branch = BranchManager.getBranch(branchId);
                    if (eventType == BranchEventType.Committed) {
                        Artifact artifact = BranchManager.getAssociatedArtifact((BranchId)branch);
                        TransactionManager.clearCommitArtifactCacheForAssociatedArtifact((ArtifactId)artifact);
                        this.updateBranchState(BranchState.COMMITTED, branch);
                    } else if (eventType == BranchEventType.Purged) {
                        this.updateBranchState(BranchState.PURGED, branch);
                    } else if (eventType == BranchEventType.Deleted) {
                        this.updateBranchState(BranchState.DELETED, branch);
                    }
                }
                if (eventType.justifiesCacheRefresh()) {
                    BranchManager.resetWasLoaded();
                }
            }
        }
        catch (Exception ex) {
            EventUtil.eventLog((String)"REM: updateBranches", (Throwable)ex);
        }
    }

    private void updateBranchState(BranchState state, Branch branch) {
        if (state.matches(new Id[]{BranchState.PURGED, BranchState.DELETED})) {
            branch.setArchived(true);
            BranchManager.decache(branch);
        }
        branch.setBranchState(state);
    }
}

