/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.util.HashMap;
import java.util.Map;

public enum DoorsColumnType {
    ID("ID"),
    REQUIREMENTS("Requirements"),
    OBJECT_NUMBER("Object Number"),
    IS_REQ("Req?"),
    PARENT_ID("Parent ID"),
    EFFECTIVITY("Effectivity"),
    PARAGRAPH_HEADING("Paragraph Heading"),
    DOCUMENT_APPLICABILITY("Document Applicability"),
    VERIFICATION_CRITERIA("Verification Criteria"),
    CHANGE_STATUS("Change Status"),
    OBJECT_HEADING("Proposed Object Heading"),
    OBJECT_TEXT("Proposed Object Text"),
    CHANGE_RATIONALE("Change Rationale"),
    LINKS("Links"),
    GUID("OSEE GUID"),
    SUBSYSTEM("Subsystem"),
    DATA_TYPE("Data Type"),
    OTHER("");

    private final String columnType;
    private static final Map<String, DoorsColumnType> rawStringToDataType;

    static {
        rawStringToDataType = new HashMap<String, DoorsColumnType>();
        DoorsColumnType[] doorsColumnTypeArray = DoorsColumnType.values();
        int n = doorsColumnTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DoorsColumnType enumStatus = doorsColumnTypeArray[n2];
            rawStringToDataType.put(enumStatus.columnType, enumStatus);
            ++n2;
        }
    }

    private DoorsColumnType(String columnName) {
        this.columnType = columnName;
    }

    public static DoorsColumnType fromString(String value) {
        DoorsColumnType returnVal;
        if (value.contains("Verification Criteria")) {
            value = "Verification Criteria";
        }
        return (returnVal = rawStringToDataType.get(value)) != null ? returnVal : OTHER;
    }
}

