/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.panels.IOverrideHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SelectionComposite
extends Composite {
    private static final Image CONFLICT_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.OBSTRUCTED);
    private static final Image CHECKED_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.CHECKBOX_ENABLED);
    private static final Image UNCHECKED_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.CHECKBOX_DISABLED);
    private static Image CHECK_OVERRIDEN_IMAGE = null;
    private static Image UNCHECKED_OVERRIDEN_IMAGE = null;
    private final ITableLabelProvider tableLabelProvider;
    private TableViewer tableViewer;
    private final Object[] resources;
    private final boolean isSelectAllByDefault;
    private final Map<Object, MutableBoolean> selectableMap;
    private final Set<Object> userSelectedResources = new HashSet<Object>();
    private final Set<Object> notSelectableResources = new HashSet<Object>();
    private final Set<Object> overridable = new HashSet<Object>();
    private final String[] columnNames;
    private Label lblSelectedResourcesNumber;
    private IOverrideHandler overrideHandler;
    private boolean areOverridesAllowed;

    public SelectionComposite(Composite parent, int style, String[] columnNames, ITableLabelProvider tableLabelProvider, Object[] resources, boolean isSelectAllByDefault, IOverrideHandler overrideHandler) {
        this(parent, style, columnNames, tableLabelProvider, resources, isSelectAllByDefault, null, null, overrideHandler);
    }

    public SelectionComposite(Composite parent, int style, String[] columnNames, ITableLabelProvider tableLabelProvider, Object[] resources, boolean isSelectAllByDefault, Object[] userSelectedResources, Object[] unSelectableResources, IOverrideHandler overrideHandler) {
        super(parent, style);
        this.columnNames = columnNames;
        this.tableLabelProvider = tableLabelProvider;
        this.selectableMap = new HashMap<Object, MutableBoolean>();
        this.resources = resources;
        this.isSelectAllByDefault = isSelectAllByDefault;
        if (userSelectedResources != null) {
            this.userSelectedResources.addAll(Arrays.asList(userSelectedResources));
        }
        if (unSelectableResources != null) {
            this.notSelectableResources.addAll(Arrays.asList(unSelectableResources));
        }
        this.overrideHandler = overrideHandler;
        if (overrideHandler != null) {
            try {
                this.overridable.addAll(overrideHandler.getOverridableFromUnselectable(this.notSelectableResources));
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        this.areOverridesAllowed = false;
        this.createControls();
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createTableArea(this);
        Composite buttonComposite = this.createButtonArea(this);
        this.createLabelArea(buttonComposite);
    }

    private void createTableArea(Composite parent) {
        int style = 68354;
        Table table = new Table(parent, style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        viewerColumn.setEditingSupport((EditingSupport)new CheckColumnEditingSupport((ColumnViewer)this.tableViewer));
        viewerColumn.setLabelProvider((CellLabelProvider)new CheckCellLabelProvider());
        this.createColumns();
        this.initializeSelections();
        this.tableViewer.setInput((Object)this.resources);
        this.packColumnData();
    }

    private void packColumnData() {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private void createColumns() {
        Table table = this.tableViewer.getTable();
        String[] stringArray = this.columnNames;
        int n = this.columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setResizable(true);
            column.setText(item);
            ++n2;
        }
    }

    private void createLabelArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.lblSelectedResourcesNumber = new Label(composite, 131072);
        this.lblSelectedResourcesNumber.setText(this.selectItemsToString(this.getSelectedCount()));
        this.lblSelectedResourcesNumber.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Composite createButtonArea(Composite parent) {
        Composite composite = new Composite(parent, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = this.overrideHandler != null ? 4 : 3;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Button selectButton = new Button(composite, 8);
        selectButton.setText("Select All");
        selectButton.setLayoutData((Object)new GridData());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionComposite.this.setAllItemsChecked(true);
            }
        });
        Button deselectButton = new Button(composite, 8);
        deselectButton.setText("Deselect All");
        deselectButton.setLayoutData((Object)new GridData());
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionComposite.this.setAllItemsChecked(false);
            }
        });
        if (this.overrideHandler != null) {
            final Button overrideButton = new Button(composite, 32);
            overrideButton.setText(this.overrideHandler.getText());
            overrideButton.setToolTipText(this.overrideHandler.getToolTipText());
            overrideButton.setLayoutData((Object)new GridData());
            overrideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectionComposite.this.areOverridesAllowed = overrideButton.getSelection();
                    if (SelectionComposite.this.areOverridesAllowed) {
                        for (Object object : SelectionComposite.this.overridable) {
                            SelectionComposite.this.selectableMap.put(object, new MutableBoolean(false));
                        }
                    } else {
                        for (Object object : SelectionComposite.this.overridable) {
                            SelectionComposite.this.selectableMap.remove(object);
                        }
                    }
                    SelectionComposite.this.refresh();
                }
            });
        }
        return composite;
    }

    private void setAllItemsChecked(boolean state) {
        for (Object key : this.selectableMap.keySet()) {
            MutableBoolean mutable = this.selectableMap.get(key);
            mutable.setValue(state);
            this.selectableMap.put(key, mutable);
        }
        this.refresh();
    }

    private void refresh() {
        this.lblSelectedResourcesNumber.setText(this.selectItemsToString(this.getSelectedCount()));
        this.tableViewer.refresh();
    }

    protected void initializeSelections() {
        Object[] objectArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!this.notSelectableResources.contains(object)) {
                boolean initialValue = this.userSelectedResources.contains(object) || this.isSelectAllByDefault;
                this.selectableMap.put(object, new MutableBoolean(initialValue));
            }
            ++n2;
        }
    }

    protected String selectItemsToString(int value) {
        return String.format("Selected: %s of %s", String.valueOf(value), String.valueOf(this.resources.length));
    }

    public void addOverrideHandler(IOverrideHandler overrideHandler) {
        this.overrideHandler = overrideHandler;
    }

    public Object[] getSelectedResources() {
        return this.getSelectedItems(true);
    }

    public Object[] getNotSelectedResources() {
        return this.getSelectedItems(false);
    }

    private Object[] getSelectedItems(boolean thatMatchTrue) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        for (Object key : this.selectableMap.keySet()) {
            if (this.selectableMap.get(key).getValue() != thatMatchTrue) continue;
            toReturn.add(key);
        }
        return toReturn.toArray(new Object[toReturn.size()]);
    }

    public int getSelectedCount() {
        int count = 0;
        for (MutableBoolean value : this.selectableMap.values()) {
            if (!value.getValue()) continue;
            ++count;
        }
        return count;
    }

    private boolean isOverridable(Object element) {
        return this.overridable.contains(element) && this.areOverridesAllowed;
    }

    private final class CheckCellLabelProvider
    extends CellLabelProvider {
        public void update(ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                Object data = cell.getItem().getData();
                if (SelectionComposite.this.notSelectableResources.contains(data) && !SelectionComposite.this.isOverridable(data)) {
                    cell.setImage(CONFLICT_IMAGE);
                } else {
                    MutableBoolean isSelectedObject = (MutableBoolean)SelectionComposite.this.selectableMap.get(data);
                    boolean isSelected = isSelectedObject != null && isSelectedObject.getValue();
                    boolean isOverriden = SelectionComposite.this.overridable.contains(data);
                    cell.setImage(this.getImage(isSelected, isOverriden));
                }
            }
        }

        private Image getImage(boolean isChecked, boolean isOverriden) {
            Image toReturn;
            Image image = toReturn = isChecked ? CHECKED_IMAGE : UNCHECKED_IMAGE;
            if (isOverriden) {
                if (CHECK_OVERRIDEN_IMAGE == null || UNCHECKED_OVERRIDEN_IMAGE == null) {
                    DecorationOverlayIcon overlay = new DecorationOverlayIcon(toReturn, ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.SWITCHED), 3);
                    Image overlayedImage = overlay.createImage();
                    if (isChecked) {
                        CHECK_OVERRIDEN_IMAGE = overlayedImage;
                    } else {
                        UNCHECKED_OVERRIDEN_IMAGE = overlayedImage;
                    }
                }
                toReturn = isChecked ? CHECK_OVERRIDEN_IMAGE : UNCHECKED_OVERRIDEN_IMAGE;
            }
            return toReturn;
        }
    }

    private final class CheckColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public CheckColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor((Composite)viewer.getControl());
            viewer.setCellEditors(new CellEditor[]{this.editor});
        }

        protected boolean canEdit(Object element) {
            return !SelectionComposite.this.notSelectableResources.contains(element) || SelectionComposite.this.overridable.contains(element);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            MutableBoolean value = (MutableBoolean)SelectionComposite.this.selectableMap.get(element);
            return value != null ? value.getValue() : false;
        }

        protected void setValue(Object element, Object value) {
            MutableBoolean object = (MutableBoolean)SelectionComposite.this.selectableMap.get(element);
            if (object != null) {
                object.setValue(((Boolean)value).booleanValue());
            }
            SelectionComposite.this.refresh();
        }
    }

    private final class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return SelectionComposite.this.resources;
        }
    }
}

