/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRequirementDifferencesOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.render.RenderingUtil;
import org.eclipse.osee.framework.ui.skynet.util.ArtifactTypeAndDescriptiveLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;
import org.eclipse.ui.progress.UIJob;

public class ShowRelatedRequirementDiffsAction
extends AbstractShowRelatedAction {
    public ShowRelatedRequirementDiffsAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Show Requirement Diffs", selectedAtsArtifacts);
    }

    public void run() {
        final Collection<IAtsTask> tasks = this.getSelectedTasks();
        if (!this.isAutoGenRelatedArtTasks(tasks)) {
            return;
        }
        Job job = new Job("Show Requirement Diffs"){

            protected IStatus run(IProgressMonitor monitor) {
                ShowRequirementDifferencesOperation operation = new ShowRequirementDifferencesOperation(new UISelectArtifactsToDiff(), tasks, false);
                Operations.executeAsJob((IOperation)operation, (boolean)true, (int)20, null);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private static final class UISelectArtifactsToDiff
    implements ShowRequirementDifferencesOperation.Display {
        private UISelectArtifactsToDiff() {
        }

        @Override
        public Artifact getArtifactSelection(IProgressMonitor monitor, final Collection<? extends Artifact> selectableArtifacts) throws Exception {
            final Artifact[] selectedArtifact = new Artifact[1];
            UIJob job = new UIJob("Select artifacts to diff"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog("Select Artifact", "Multiple artifacts of same name.  Select Artifact to Diff", selectableArtifacts, (ILabelProvider)new ArtifactTypeAndDescriptiveLabelProvider());
                    dialog.setMultiSelect(false);
                    int result = dialog.open();
                    if (result == 0) {
                        selectedArtifact[0] = dialog.getSelectedFirst();
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            Jobs.startJob((Job)job);
            job.join();
            Operations.checkForErrorStatus((IStatus)job.getResult());
            return selectedArtifact[0];
        }

        @Override
        public void showDifferences(Collection<ArtifactDelta> artifactDeltas) {
            Conditions.checkNotNullOrEmpty(artifactDeltas, (String)"selected artifact change from change report");
            String pathPrefix = RenderingUtil.getAssociatedArtifactName(artifactDeltas);
            RendererManager.diffInJob(artifactDeltas, (String)pathPrefix);
        }
    }
}

