/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.IDuplicateWorkflowListener;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.ats.ide.workflow.duplicate.CloneWorkflowAction;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CloneActionToGoalAction
extends Action {
    private final CollectorArtifact collectorArt;
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private final IMemberProvider memberProvider;

    public CloneActionToGoalAction(IMemberProvider memberProvider, CollectorArtifact collectorArt, ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Clone Selected Action At This Location");
        this.memberProvider = memberProvider;
        this.collectorArt = collectorArt;
        this.selectedAtsArtifacts = selectedAtsArtifacts;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DUPLICATE);
    }

    public void run() {
        try {
            Artifact dropTarget;
            List<Artifact> selected = this.selectedAtsArtifacts.getSelectedAtsArtifacts();
            Artifact artifact = dropTarget = selected.isEmpty() ? null : (Artifact)selected.iterator().next();
            if (dropTarget == null) {
                AWorkbench.popup((String)"Must select single workflow to clone");
                return;
            }
            IAtsTeamWorkflow teamWf = null;
            if (!(dropTarget instanceof IAtsTeamWorkflow) && !((IAtsTeamWorkflow)dropTarget).isChangeRequest()) {
                AWorkbench.popup((String)"Can only clone workflow");
                return;
            }
            teamWf = (IAtsTeamWorkflow)dropTarget;
            CloneWorkflowAction cloneAction = new CloneWorkflowAction(teamWf, new IDuplicateWorkflowListener(){

                public IAtsGoal addToGoal(IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
                    IAtsGoal goal = null;
                    List related = CloneActionToGoalAction.this.collectorArt.getRelatedArtifacts(CloneActionToGoalAction.this.memberProvider.getMemberRelationTypeSide());
                    if (!related.contains(teamWf.getStoreObject())) {
                        changes.relate((ArtifactId)CloneActionToGoalAction.this.collectorArt, CloneActionToGoalAction.this.memberProvider.getMemberRelationTypeSide(), (ArtifactId)teamWf.getStoreObject());
                    }
                    CloneActionToGoalAction.this.collectorArt.setRelationOrder(CloneActionToGoalAction.this.memberProvider.getMemberRelationTypeSide(), dropTarget, false, AtsApiService.get().getQueryServiceIde().getArtifact(teamWf));
                    if (CloneActionToGoalAction.this.collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                        AtsApiService.get().getGoalMembersCache().decache((GoalArtifact)CloneActionToGoalAction.this.collectorArt);
                    } else if (CloneActionToGoalAction.this.memberProvider.isSprint()) {
                        AtsApiService.get().getSprintItemsCache().decache((SprintArtifact)CloneActionToGoalAction.this.collectorArt);
                    }
                    changes.add((Object)CloneActionToGoalAction.this.collectorArt);
                    return goal;
                }
            });
            cloneAction.run();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void refreshText() {
        this.setText(this.getText());
    }

    public static interface RemovedFromCollectorHandler {
        public void removedFromCollector(Collection<? extends Artifact> var1);
    }
}

