/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkWfdForProgramAi;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.ISelectableValueProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelDate;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkTriStateBoolean;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkWfdForEnum;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkWfdForEnumAttr;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XRadioButtonsBooleanTriState;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CreateNewChangeRequestBlam
extends AbstractBlam
implements INewActionListener,
ISelectableValueProvider {
    public static final String DEBUG_DESCRIPTION = "Description...";
    private static final String BLAM_DESCRIPTION = "Create program top level Demo Change Request for any new feature or problem found.\nThis will mature into all the work for all teams needed to resolve this request.";
    protected static final String TITLE = "Title";
    protected static final String PROGRAM = "Program";
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String NEED_BY = AtsAttributeTypes.NeedBy.getUnqualifiedName();
    protected XText titleWidget;
    protected XText descWidget;
    protected XHyperlinkWfdForEnum changeWidgetEnum;
    protected XHyperlinkWfdForEnumAttr changeWidgetEnumAttr;
    protected XHyperlinkWfdForEnumAttr priorityWidget;
    protected final AtsApi atsApi = AtsApiService.get();
    protected XWidgetBuilder wb;
    private ActionResult actionResult;
    protected XHyperlinkWfdForProgramAi programWidget;
    private XHyperlinkTriStateBoolean crashWidget;
    private XHyperlinkLabelDate needByWidget;
    private String overrideTitle;

    public CreateNewChangeRequestBlam(String name) {
        super(name, BLAM_DESCRIPTION, null);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        this.wb = new XWidgetBuilder();
        this.wb.andWidget(PROGRAM, XHyperlinkWfdForProgramAi.class.getSimpleName()).andValueProvider((ISelectableValueProvider)this).andRequired().endWidget();
        this.wb.andXText(TITLE).andRequired().endWidget();
        this.wb.andXText((AttributeTypeToken)AtsAttributeTypes.Description).andHeight(80).andRequired().endWidget();
        this.wb.andXHyperLinkEnumAttr((AttributeTypeToken)AtsAttributeTypes.ChangeType).andComposite(6).andRequired().endWidget();
        this.wb.andXHyperLinkEnumAttr(this.getPriorityAttrType()).andRequired().endWidget();
        this.wb.andXHyperLinkDate(AtsAttributeTypes.NeedBy.getUnqualifiedName()).endComposite().endComposite().endWidget();
        this.wb.andXHyperlinkTriStateBoolean(AtsAttributeTypes.CrashOrBlankDisplay.getUnqualifiedName()).andRequired().endWidget();
        return this.wb.getItems();
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(TITLE)) {
            this.titleWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(DESCRIPTION)) {
            this.descWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            if (xWidget instanceof XHyperlinkWfdForEnumAttr) {
                this.changeWidgetEnumAttr = (XHyperlinkWfdForEnumAttr)xWidget;
            } else if (xWidget instanceof XHyperlinkWfdForEnum) {
                this.changeWidgetEnum = (XHyperlinkWfdForEnum)xWidget;
            }
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XHyperlinkWfdForEnumAttr)xWidget;
        } else if (xWidget.getLabel().equals(NEED_BY)) {
            this.needByWidget = (XHyperlinkLabelDate)xWidget;
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XHyperlinkWfdForEnumAttr)xWidget;
        } else if (xWidget.getLabel().equals(AtsAttributeTypes.CrashOrBlankDisplay.getUnqualifiedName())) {
            this.crashWidget = (XHyperlinkTriStateBoolean)xWidget;
        } else if (xWidget.getLabel().equals(PROGRAM) && xWidget instanceof XHyperlinkWfdForProgramAi) {
            this.programWidget = (XHyperlinkWfdForProgramAi)xWidget;
            this.programWidget.getLabelHyperlink().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    if (event.button == 3) {
                        CreateNewChangeRequestBlam.this.handlePopulateWithDebugInfo();
                    }
                }
            });
            Collection<IAtsActionableItem> selectable = this.programWidget.getSelectable();
            if (selectable.size() == 1) {
                this.programWidget.setSelected(selectable.iterator().next());
                this.programWidget.refresh();
            }
        }
    }

    public abstract Collection<IAtsActionableItem> getProgramCrAis();

    protected String getDebugTitle() {
        return "New CR " + this.atsApi.getRandomNum();
    }

    public void handlePopulateWithDebugInfo() {
        try {
            this.titleWidget.set(Strings.isValid((String)this.overrideTitle) ? this.overrideTitle : this.getDebugTitle());
            this.descWidget.set(DEBUG_DESCRIPTION);
            if (this.changeWidgetEnum != null) {
                this.changeWidgetEnum.setSelected((Object)ChangeType.Problem.name());
            }
            if (this.changeWidgetEnumAttr != null) {
                this.changeWidgetEnumAttr.setSelected((Object)ChangeType.Problem.name());
            }
            if (this.priorityWidget != null) {
                this.priorityWidget.setSelected((Object)"3");
            }
            if (this.crashWidget != null) {
                this.crashWidget.setSelected(XRadioButtonsBooleanTriState.BooleanState.Yes);
            }
            if (this.needByWidget != null) {
                this.needByWidget.setDateValue(new Date());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        XRadioButtonsBooleanTriState.BooleanState crash;
        String desc;
        IAtsActionableItem programAi;
        this.variableMap = variableMap;
        this.actionResult = new ActionResult(null, null);
        XResultData results = this.actionResult.getResults();
        String title = variableMap.getString(TITLE);
        if (Strings.isInValid((String)title)) {
            results.error("Enter Title");
        }
        if ((programAi = (IAtsActionableItem)variableMap.getValue(PROGRAM)) == null || programAi.isInvalid()) {
            results.error("Select Program");
        }
        if (Strings.isInValid((String)(desc = variableMap.getString(DESCRIPTION)))) {
            results.error("Enter Description");
        }
        String changeType = variableMap.getString(CHANGE_TYPE);
        ChangeType cType = null;
        if (this.changeWidgetEnum != null || this.changeWidgetEnumAttr != null) {
            if (Strings.isInValid((String)changeType) || "--select--".equals(changeType)) {
                if (this.changeWidgetEnum != null && this.changeWidgetEnum.isRequiredEntry()) {
                    results.error("Select Change type");
                } else if (this.changeWidgetEnumAttr != null && this.changeWidgetEnumAttr.isRequiredEntry()) {
                    results.error("Select Change type");
                }
            } else {
                try {
                    cType = ChangeType.valueOf((String)changeType);
                }
                catch (Exception exception) {
                    results.error("Invalid Change Type");
                }
            }
        }
        String priority = "";
        if (this.priorityWidget != null && (Strings.isInValid((String)(priority = variableMap.getString(PRIORITY))) || "--select--".equals(priority)) && this.priorityWidget.isRequiredEntry()) {
            results.error("Select Priority");
        }
        if (this.crashWidget != null && (crash = (XRadioButtonsBooleanTriState.BooleanState)variableMap.getValue(AtsAttributeTypes.CrashOrBlankDisplay.getUnqualifiedName())).isUnSet() && this.crashWidget.isRequiredEntry()) {
            results.error("Select " + AtsAttributeTypes.CrashOrBlankDisplay.getUnqualifiedName());
        }
        Date needBy = null;
        if (this.needByWidget != null) {
            needBy = (Date)variableMap.getValue(NEED_BY);
            if (this.needByWidget.isRequiredEntry()) {
                results.error("Select Need By");
            }
        }
        this.isValidEntry(results);
        this.log(new String[]{results.toString()});
        if (results.isErrors()) {
            return;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getName());
        this.actionResult = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), title, desc, cType, priority, false, needBy, Collections.singleton(programAi), new Date(), this.atsApi.getUserService().getCurrentUser(), Collections.singleton(this), changes);
        changes.execute();
        if (this.actionResult.getResults().isErrors()) {
            this.log(new String[]{this.actionResult.getResults().toString()});
            return;
        }
        IAtsTeamWorkflow teamWf = this.actionResult.getFirstTeam();
        WorkflowEditor.edit((IAtsWorkItem)teamWf);
    }

    public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
        if (this.crashWidget != null) {
            XRadioButtonsBooleanTriState.BooleanState state = this.crashWidget.getSelected();
            boolean checked = true;
            if (state.isUnSet()) {
                checked = false;
            }
            changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.CrashOrBlankDisplay, (Object)checked);
        }
    }

    public Collection<IAtsVersion> getSelectedProgramVersions() {
        IAtsTeamDefinition progTeamDef = this.getSelectedProgramTeamDefOrSentinel();
        if (progTeamDef.isValid()) {
            return this.atsApi.getVersionService().getVersionsFromTeamDefHoldingVersions(progTeamDef);
        }
        return Collections.emptyList();
    }

    public IAtsTeamDefinition getSelectedProgramTeamDefOrSentinel() {
        IAtsTeamDefinition progTeamDef = IAtsTeamDefinition.SENTINEL;
        IAtsActionableItem progAi = this.getSelectedProgramAiOrSentinel();
        if (progAi.isValid()) {
            progTeamDef = this.atsApi.getActionableItemService().getTeamDefinitionInherited(progAi);
        }
        return progTeamDef;
    }

    public IAtsActionableItem getSelectedProgramAiOrSentinel() {
        IAtsActionableItem selected = (IAtsActionableItem)this.programWidget.getSelected();
        if (selected != null) {
            return selected;
        }
        return IAtsActionableItem.SENTINEL;
    }

    public abstract String getRunText();

    public String getOutputMessage() {
        return "Not yet run.";
    }

    public String getTabTitle() {
        return "Change Request";
    }

    public String getTitle() {
        return this.getName();
    }

    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavItemCat.TOP_NEW);
    }

    protected AttributeTypeToken getPriorityAttrType() {
        return AtsAttributeTypes.Priority;
    }

    public Collection<Object> getSelectable(XWidget widget) {
        if (widget instanceof XHyperlinkWfdForProgramAi) {
            return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getProgramCrAis());
        }
        return Collections.emptyList();
    }

    public void setOverrideTitle(String overrideTitle) {
        this.overrideTitle = overrideTitle;
    }
}

