/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.KindType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;

public class ValidationReportOperation
extends AbstractOperation {
    private final TeamWorkFlowArtifact teamArt;
    private final Set<AbstractValidationRule> rules;
    private final XResultData results;

    public ValidationReportOperation(XResultData results, TeamWorkFlowArtifact teamArt, Set<AbstractValidationRule> rules) {
        super("Validate Requirement Changes - " + teamArt.getName(), "org.eclipse.osee.ats.ide", null);
        this.results = results;
        this.teamArt = teamArt;
        this.rules = rules;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.results.logf("<b>Validating Requirement Changes for %s</b>\n", new Object[]{this.teamArt.getName()});
        ArrayList<AbstractValidationRule> rulesSorted = new ArrayList<AbstractValidationRule>(this.rules);
        Collections.sort(rulesSorted, new ValidationRuleComparator());
        this.results.log("<b>NOTE: </b>All errors are shown for artifact state on branch or at time of commit.  Select hyperlink to open most recent version of artifact.");
        try {
            ChangeData changeData = AtsApiService.get().getBranchServiceIde().getChangeDataFromEarliestTransactionId(this.teamArt);
            Collection changedArtifacts = changeData.getArtifacts(KindType.ArtifactOrRelation, new ModificationType[]{ModificationType.APPLICABILITY, ModificationType.INTRODUCED, ModificationType.MERGED, ModificationType.REPLACED_WITH_VERSION, ModificationType.UNDELETED, ModificationType.NEW, ModificationType.MODIFIED});
            ValidationReportOperation.checkForCancelledStatus((IProgressMonitor)monitor);
            double total = changedArtifacts.size() * this.rules.size();
            if (total > 0.0) {
                int workAmount = this.calculateWork(1.0 / total);
                String lastTitle = "";
                int ruleIndex = 1;
                for (AbstractValidationRule rule : rulesSorted) {
                    ValidationReportOperation.checkForCancelledStatus((IProgressMonitor)monitor);
                    String currentTitle = rule.getRuleTitle();
                    if (!lastTitle.equals(currentTitle)) {
                        this.processNewTitle(rule, rulesSorted, this.results);
                        lastTitle = rule.getRuleTitle();
                    }
                    if (this.isSkipRelationCheck(rule.getRuleTitle())) {
                        this.results.logf("INFO: Relations Check skipped:  detected committed branches.", new Object[0]);
                    } else if (this.isSkipOrphanCheck(rule.getRuleTitle())) {
                        this.results.logf("INFO: Orphan Check skipped", new Object[0]);
                    } else {
                        int artIndex = 1;
                        for (Artifact art : changedArtifacts) {
                            try {
                                monitor.setTaskName(String.format("Validating: Rule[%s of %s] Artifact[%s of %s]", ruleIndex, this.rules.size(), artIndex, changedArtifacts.size()));
                                ValidationReportOperation.checkForCancelledStatus((IProgressMonitor)monitor);
                                rule.validate((ArtifactToken)art, this.results);
                            }
                            catch (Exception ex) {
                                this.results.logf("Exception processing artifact %s Exception ex: %s\n", new Object[]{art.toStringWithId(), ex.getMessage()});
                            }
                            monitor.worked(workAmount);
                            ++artIndex;
                        }
                    }
                    ++ruleIndex;
                }
            }
            this.results.log("\n<b>Validation Complete</b>");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            this.results.error(Lib.exceptionToString((Exception)ex));
        }
    }

    private void processNewTitle(AbstractValidationRule newRule, List<AbstractValidationRule> rulesSorted, XResultData results) {
        results.logf("\n<b>%s</b>\n", new Object[]{newRule.getRuleTitle()});
        for (AbstractValidationRule rule : rulesSorted) {
            if (!rule.getRuleTitle().equals(newRule.getRuleTitle())) continue;
            results.logf("%s\n", new Object[]{rule.getRuleDescription()});
        }
        results.logf("========================================\n", new Object[0]);
    }

    private boolean isSkipOrphanCheck(String ruleTitle) {
        return ruleTitle.equals("Orphan Validation Checks");
    }

    private boolean isSkipRelationCheck(String ruleTitle) {
        AtsApiIde atsApi = AtsApiService.get();
        Conditions.checkNotNull((Object)atsApi, (String)"AtsApiService");
        IAtsBranchService branchService = atsApi.getBranchService();
        Conditions.checkNotNull((Object)branchService, (String)"AtsBranchService");
        return branchService.isBranchesAllCommitted((IAtsTeamWorkflow)this.teamArt) && ruleTitle.equals("Relations Check:");
    }

    private final class ValidationRuleComparator
    implements Comparator<AbstractValidationRule> {
        private ValidationRuleComparator() {
        }

        @Override
        public int compare(AbstractValidationRule o1, AbstractValidationRule o2) {
            String title1 = o1.getRuleTitle();
            String title2 = o2.getRuleTitle();
            if (title1 == null) {
                title1 = "";
            }
            if (title2 == null) {
                title2 = "";
            }
            return title1.compareTo(title2);
        }
    }
}

