/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class AtsArtifactQuery {
    public static Artifact getArtifactFromId(String guidOrAtsId) {
        LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
        if (GUID.isValid((String)guidOrAtsId)) {
            artifacts.add(ArtifactQuery.getArtifactFromId((String)guidOrAtsId, (BranchId)AtsApiService.get().getAtsBranch()));
        } else {
            artifacts.addAll(ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)AtsAttributeTypes.AtsId, Collections.singleton(guidOrAtsId), (BranchId)AtsApiService.get().getAtsBranch(), (int)1));
        }
        if (artifacts.isEmpty()) {
            throw new ArtifactDoesNotExist("AtsArtifactQuery: No artifact found with id %s on ATS branch", new Object[]{guidOrAtsId});
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsExist("%d artifacts found with id %s", new Object[]{artifacts.size(), guidOrAtsId});
        }
        return (Artifact)artifacts.iterator().next();
    }

    public static List<Artifact> getArtifactListFromIds(Collection<String> guidsOrAtsIds) {
        List fromIds;
        LinkedList<Artifact> toReturn = new LinkedList<Artifact>();
        LinkedList<String> guids = new LinkedList<String>();
        LinkedList<String> atsIds = new LinkedList<String>();
        for (String guidOrAtsId : guidsOrAtsIds) {
            if (GUID.isValid((String)guidOrAtsId)) {
                guids.add(guidOrAtsId);
                continue;
            }
            atsIds.add(guidOrAtsId.toUpperCase());
        }
        if (!guids.isEmpty()) {
            fromIds = ArtifactQuery.getArtifactListFromIds(guids, (BranchId)AtsApiService.get().getAtsBranch());
            toReturn.addAll(fromIds);
        }
        if (!atsIds.isEmpty()) {
            fromIds = ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)AtsAttributeTypes.AtsId, atsIds, (BranchId)AtsApiService.get().getAtsBranch(), (int)atsIds.size());
            toReturn.addAll(fromIds);
        }
        return toReturn;
    }

    public static Artifact getArtifactFromId(long id) {
        return ArtifactQuery.getArtifactFromId((ArtifactId)ArtifactId.valueOf((Long)id), (BranchId)AtsApiService.get().getAtsBranch());
    }

    public static Artifact getArtifactFromIdOrNull(Long id) {
        return ArtifactQuery.getArtifactOrNull((ArtifactId)ArtifactId.valueOf((Long)id), (BranchId)AtsApiService.get().getAtsBranch(), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
    }
}

