/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.actions.MyFavoritesAction;
import org.eclipse.osee.ats.ide.actions.MyWorldAction;
import org.eclipse.osee.ats.ide.actions.NewAction;
import org.eclipse.osee.ats.ide.actions.OpenChangeReportByIdAction;
import org.eclipse.osee.ats.ide.actions.OpenWorkflowByIdAction;
import org.eclipse.osee.ats.ide.actions.OpenWorldByIdAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateComposite;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItemsOperation;
import org.eclipse.osee.ats.ide.navigate.ToggleAtsAdmin;
import org.eclipse.osee.ats.ide.search.AtsQuickSearchComposite;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.plugin.util.WorkbenchTargetProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.INavigateItemRefresher;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateEventListener;
import org.eclipse.osee.framework.ui.plugin.xnavigate.NavigateItemCollector;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateEventManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemProviders;
import org.eclipse.osee.framework.ui.skynet.OseeStatusContributionItemFactory;
import org.eclipse.osee.framework.ui.skynet.OseeTargetContributionItem;
import org.eclipse.osee.framework.ui.skynet.action.CollapseAllAction;
import org.eclipse.osee.framework.ui.skynet.action.ExpandAllAction;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionExceptionComposite;
import org.eclipse.osee.framework.ui.skynet.util.LoadingComposite;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class NavigateView
extends ViewPart
implements IXNavigateEventListener,
RefreshAction.IRefreshActionHandler,
INavigateItemRefresher {
    public static final String VIEW_ID = "org.eclipse.osee.navigate.NavigateView";
    private static final String INPUT = "filter";
    private static final String FILTER_STR = "filterStr";
    private static NavigateView navView;
    private String savedFilterStr;
    private AtsNavigateComposite xNavComp;
    private Composite parent;
    private LoadingComposite loadingComposite;
    private NavigateItemCollector itemCollector;
    private XResultData rd;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        navView = this;
        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)parent)) {
            AtsApiService.get().userService().getMyUserGroups();
            this.loadingComposite = new LoadingComposite(parent);
            this.refreshData();
        }
    }

    public void refreshData() {
        OperationBuilder builder = Operations.createBuilder((String)"Load OSEE Navigator");
        this.rd = new XResultData();
        this.itemCollector = new NavigateItemCollector((Collection)XNavigateItemProviders.getProviders(), (INavigateItemRefresher)navView, this.rd);
        builder.addOp((IOperation)new AtsNavigateViewItemsOperation(this.itemCollector));
        Operations.executeAsJob((IOperation)builder.build(), (boolean)false, (int)30, (IJobChangeListener)new ReloadJobChangeAdapter(this));
    }

    public void refresh(XNavigateItem item) {
        if (this.xNavComp != null && Widgets.isAccessible((Widget)this.xNavComp.getFilteredTree()) && Widgets.isAccessible((Widget)this.xNavComp.getFilteredTree().getViewer().getTree())) {
            this.xNavComp.getFilteredTree().getViewer().refresh((Object)item);
        }
    }

    private void addExtensionPointListenerBecauseOfWorkspaceLoading() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        extensionRegistry.addListener(new IRegistryEventListener(){

            public void added(IExtension[] extensions) {
                NavigateView.this.refreshNavComp();
            }

            public void added(IExtensionPoint[] extensionPoints) {
                NavigateView.this.refreshNavComp();
            }

            public void removed(IExtension[] extensions) {
                NavigateView.this.refreshNavComp();
            }

            public void removed(IExtensionPoint[] extensionPoints) {
                NavigateView.this.refreshNavComp();
            }
        }, "org.eclipse.osee.framework.ui.skynet.BlamOperation");
    }

    private void refreshNavComp() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                NavigateView.this.xNavComp.refresh();
            }
        });
    }

    private String getWhoAmI() {
        try {
            String userName = AtsApiService.get().userService().getUser().getName();
            return String.format("[%s] - [%s]", AtsApiService.get().getAtsBranch().getName(), userName);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    protected void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)new RefreshAction((RefreshAction.IRefreshActionHandler)this));
        toolbarManager.add((IAction)new MyWorldAction());
        toolbarManager.add((IAction)new MyFavoritesAction());
        toolbarManager.add((IAction)new CollapseAllAction(this.xNavComp.getFilteredTree().getViewer()));
        toolbarManager.add((IAction)new ExpandAllAction(this.xNavComp.getFilteredTree().getViewer()));
        toolbarManager.add((IAction)new OpenChangeReportByIdAction());
        toolbarManager.add((IAction)new OpenWorldByIdAction());
        toolbarManager.add((IAction)new OpenWorkflowByIdAction());
        toolbarManager.add((IAction)new NewAction());
        this.getViewSite().getActionBars().updateActionBars();
        toolbarManager.update(true);
    }

    public static NavigateView getNavigateView() {
        return navView;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (DbConnectionExceptionComposite.dbConnectionIsOk()) {
            memento = memento.createChild(INPUT);
            if (this.xNavComp != null && this.xNavComp.getFilteredTree().getFilterControl() != null && !this.xNavComp.getFilteredTree().isDisposed()) {
                String filterStr = this.xNavComp.getFilteredTree().getFilterControl().getText();
                memento.putString(FILTER_STR, filterStr);
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (DbConnectionExceptionComposite.dbConnectionIsOk()) {
            try {
                if (memento != null && (memento = memento.getChild(INPUT)) != null) {
                    this.savedFilterStr = memento.getString(FILTER_STR);
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"NavigateView error on init", (Throwable)ex);
            }
        }
    }

    public void setFocus() {
        if (this.loadingComposite != null && !this.loadingComposite.isDisposed()) {
            this.loadingComposite.setFocus();
        }
    }

    public XNavigateItem getItem(long topLinkId, boolean recurseChildren) {
        TreeItem[] treeItemArray = this.xNavComp.getFilteredTree().getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            XNavigateItem treeNavItem = (XNavigateItem)treeItem.getData();
            XNavigateItem foundItem = this.getItem(treeNavItem, topLinkId, recurseChildren);
            if (foundItem != null) {
                return foundItem;
            }
            ++n2;
        }
        return null;
    }

    public XNavigateItem getItem(XNavigateItem item, long topLinkId, boolean recurseChildren) {
        if (item.getId() == topLinkId) {
            return item;
        }
        if (recurseChildren) {
            for (XNavigateItem child : item.getChildren()) {
                XNavigateItem found = this.getItem(child, topLinkId, recurseChildren);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public void refreshItems() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeItem[] treeItemArray = NavigateView.this.xNavComp.getFilteredTree().getViewer().getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    XNavigateItem treeNavItem = (XNavigateItem)treeItem.getData();
                    NavigateView.this.refreshItem(treeNavItem);
                    ++n2;
                }
            }
        });
    }

    public void refreshItem(XNavigateItem item) {
        item.refresh();
        for (XNavigateItem child : item.getChildren()) {
            this.refreshItem(child);
        }
    }

    public void refreshActionHandler() {
        this.refreshData();
        this.refreshItems();
    }

    public static boolean isAccessible() {
        return navView != null && Widgets.isAccessible((Widget)NavigateView.navView.parent);
    }

    public AtsNavigateComposite getxNavComp() {
        return this.xNavComp;
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final NavigateView navView;

        private ReloadJobChangeAdapter(NavigateView navView) {
            this.navView = navView;
        }

        public void done(IJobChangeEvent event) {
            UIJob job = new UIJob("Load OSEE Navigator"){
                private Label userLabel;

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        NavigateView.this.showBusy(false);
                        if (Widgets.isAccessible((Widget)NavigateView.this.loadingComposite)) {
                            NavigateView.this.loadingComposite.dispose();
                        } else if (Widgets.isAccessible((Widget)NavigateView.this.xNavComp)) {
                            NavigateView.this.getViewSite().getActionBars().getToolBarManager().removeAll();
                            NavigateView.this.xNavComp.dispose();
                        }
                        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)NavigateView.this.parent) && Widgets.isAccessible((Widget)NavigateView.this.parent)) {
                            NavigateView.this.xNavComp = new AtsNavigateComposite(NavigateView.this.itemCollector, NavigateView.this.parent, 0, NavigateView.this.savedFilterStr);
                            if (NavigateView.this.rd.isErrors()) {
                                XResultDataUI.report((XResultData)NavigateView.this.rd, (String)"OSEE Navigator", (Manipulations[])new Manipulations[]{Manipulations.ERROR_WARNING_HEADER, Manipulations.CONVERT_NEWLINES, Manipulations.ERROR_RED});
                            }
                            XNavigateEventManager.register((IXNavigateEventListener)ReloadJobChangeAdapter.this.navView);
                            HelpUtil.setHelp((Control)NavigateView.this.xNavComp, (HelpContext)AtsHelpContext.NAVIGATOR);
                            NavigateView.this.createToolBar();
                            new AtsQuickSearchComposite((Composite)NavigateView.this.xNavComp, 0);
                            this.userLabel = new Label((Composite)NavigateView.this.xNavComp, 0);
                            this.userLabel.addListener(8, new Listener(){

                                public void handleEvent(Event event) {
                                    ToggleAtsAdmin.run();
                                }
                            });
                            this.refreshUserLabel();
                            GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
                            gridData.heightHint = 15;
                            this.userLabel.setLayoutData((Object)gridData);
                            NavigateView.this.xNavComp.refresh();
                            NavigateView.this.parent.getParent().layout(true);
                            NavigateView.this.parent.layout(true);
                            OseeStatusContributionItemFactory.addTo((ViewPart)ReloadJobChangeAdapter.this.navView, (boolean)false);
                            NavigateView.this.addExtensionPointListenerBecauseOfWorkspaceLoading();
                            NavigateView.this.xNavComp.getFilteredTree().getFilterControl().addModifyListener(new ModifyListener(){

                                public void modifyText(ModifyEvent e) {
                                    String filterText = NavigateView.this.xNavComp.getFilteredTree().getFilterControl().getText();
                                    if (Strings.isInValid((String)filterText)) {
                                        NavigateView.this.refreshItems();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }

                public void refreshUserLabel() {
                    String str = NavigateView.this.getWhoAmI();
                    String oseeTarget = null;
                    WorkbenchTargetProvider provider = OseeTargetContributionItem.getWorkbenchProvider();
                    if (provider != null) {
                        oseeTarget = provider.getText();
                    }
                    boolean atsAdmin = AtsApiService.get().getUserService().isAtsAdmin();
                    boolean oseeTargetIsValid = Strings.isValid((String)oseeTarget);
                    if (oseeTargetIsValid) {
                        str = String.valueOf(str) + " - [" + oseeTarget + "]";
                    }
                    if (atsAdmin) {
                        str = String.valueOf(str) + " - [Admin]";
                        this.userLabel.setForeground(Displays.getSystemColor((int)3));
                    } else {
                        this.userLabel.setForeground(Displays.getSystemColor((int)9));
                    }
                    this.userLabel.setText(str);
                    str = String.valueOf(str) + " - [" + System.getProperty("user.name") + "] - [" + ClientSessionManager.getSession().getAuthenticationProtocol() + "]";
                    this.userLabel.setToolTipText(str);
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

