/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.relations;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeDragAndDrop;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.BranchIdEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.skynet.RelationsComposite;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeRelationsTab
extends WfeAbstractTab
implements RefreshAction.IRefreshActionHandler,
IArtifactEventListener {
    public static final String ID = "ats.relations.tab";
    private final WorkflowEditor editor;
    private final Artifact artifact;
    private final FormToolkit toolkit;
    private RelationsComposite relationComposite;
    private ScrolledForm scrolledForm;

    public WfeRelationsTab(WorkflowEditor editor, IAtsWorkItem workItem) {
        super(editor, ID, editor.getWorkItem(), "Relations");
        this.editor = editor;
        this.artifact = (Artifact)workItem;
        this.toolkit = editor.getToolkit();
        OseeEventManager.addListener((IEventListener)this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.scrolledForm = managedForm.getForm();
        this.bodyComp = this.scrolledForm.getBody();
        this.bodyComp.setLayout((Layout)new GridLayout(1, true));
        this.bodyComp.setLayoutData((Object)new GridData(16384, 16384, false, false));
        Label dragDropLabel = new Label(this.bodyComp, 2048);
        dragDropLabel.setText("Click here to drag this \"" + this.artifact.getArtifactTypeName() + "\"");
        GridData gd = new GridData(1808);
        gd.heightHint = 25;
        dragDropLabel.setLayoutData((Object)gd);
        new WfeDragAndDrop((Control)dragDropLabel, (AbstractWorkflowArtifact)this.workItem.getStoreObject(), "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
        this.toolkit.adapt((Control)dragDropLabel, true, true);
        this.relationComposite = new RelationsComposite((IDirtiableEditor)this.editor, this.bodyComp, 2048, this.artifact);
        this.relationComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListener();
        this.updateTitleBar(managedForm);
        this.createToolbar(managedForm);
        FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
    }

    private void addListener() {
        this.relationComposite.getTreeViewer().getTree().addMouseListener(new MouseListener(){

            private void redrawPage() {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WfeRelationsTab.this.relationComposite.layout();
                        WfeRelationsTab.this.relationComposite.getParent().layout();
                        WfeRelationsTab.this.getManagedForm().reflow(true);
                    }
                });
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                this.redrawPage();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void refreshActionHandler() {
        this.artifact.reloadAttributesAndRelations();
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.relationComposite)) {
            this.relationComposite.refresh();
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(new BranchIdEventFilter((BranchId)this.artifact.getBranch()));
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
    }
}

