/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.agile.jira.JiraDiffData;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;

public class SyncJiraAndOseeBlam
extends AbstractBlam {
    private static final String NAME = "Sync JIRA by Program Increment";

    public String getName() {
        return NAME;
    }

    public IOperation createOperation(VariableMap variableMap, OperationLogger logger) throws Exception {
        return new AbstractOperation(this.getName(), "org.eclipse.osee.ats.ide", logger, variableMap){
            final String jiraUrl;
            final String username;
            final String password;
            final String programIncrement;
            final String teamId;
            {
                this.jiraUrl = variableMap.getString("Jira URL");
                this.username = variableMap.getString("Username");
                this.password = variableMap.getString("Password");
                this.programIncrement = variableMap.getString("Program Increment");
                this.teamId = variableMap.getString("Team Id");
            }

            protected void doWork(IProgressMonitor monitor) throws Exception {
                JiraDiffData data = new JiraDiffData();
                data.setJiraUrl(this.jiraUrl);
                data.setUsername(this.username);
                data.setPassword(this.password);
                data.setProgramIncrement(this.programIncrement);
                data.setTeamId(this.teamId);
                data = AtsApiService.get().getServerEndpoints().getActionEndpoint().reportEpicDiffs(data);
                XResultDataUI.report((XResultData)data.getResults(), (String)this.getName());
            }
        };
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AgileNavigateItemProvider.AGILE);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget("Jira URL", "XText").endWidget();
        wb.andWidget("Username", "XText").endWidget();
        wb.andWidget("Password", "XText").endWidget();
        wb.andWidget("Program Increment", "XText").endWidget();
        wb.andWidget("Team Id", "XText").endWidget();
        return wb.getItems();
    }

    public String getDescriptionUsage() {
        return "Enter the base url (jira.xyz.com). Username and password for JIRA. Program Increment is the PI associated your epics (e.g. PI20). Team Id is your team id in Jira (represented by an numerical value). In the case of 401 authorization issues, check username/password and rerun the blam.";
    }
}

