/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.agile.SprintItems;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AgileFeatureGroupColumn
extends XViewerAtsColumn
implements IAtsXViewerPreComputedColumn,
IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static AgileFeatureGroupColumn instance = new AgileFeatureGroupColumn();

    public static AgileFeatureGroupColumn getInstance() {
        return instance;
    }

    private AgileFeatureGroupColumn() {
        super("ats.column.agileFeatureGroup", "Feature Group", 40, XViewerAlign.Left, false, SortDataType.String, true, "Agile Feature Group for this Item.");
    }

    public AgileFeatureGroupColumn copy() {
        AgileFeatureGroupColumn newXCol = new AgileFeatureGroupColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            if (treeItem.getData() instanceof AbstractWorkflowArtifact) {
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)((Object)treeItem.getData());
                boolean modified = AgileFeatureGroupColumn.promptChangeFeatureGroup(Arrays.asList(awa));
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    awa.persist("persist goals via alt-left-click");
                }
                if (modified) {
                    this.populateCachedValues(Collections.singleton(awa), this.preComputedValueMap);
                    xViewer.update((Object)awa, null);
                    return true;
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChangeFeatureGroup(Collection<? extends AbstractWorkflowArtifact> awas) {
        SprintItems items = new SprintItems(awas);
        if (items.isNoBacklogDetected()) {
            AWorkbench.popup((String)"Workflow(s) must belong to a Backlog to set their Feature Group.");
            return false;
        }
        if (items.isMultipleBacklogsDetected()) {
            AWorkbench.popup((String)"All workflows must belong to same Backlog.");
            return false;
        }
        AgileEndpointApi agileEp = AtsApiService.get().getServerEndpoints().getAgileEndpoint();
        long teamId = items.getCommonBacklog().getTeamId();
        FilteredCheckboxTreeDialog<JaxAgileFeatureGroup> dialog = AgileFeatureGroupColumn.openSelectionDialog(teamId, awas);
        JaxAgileItem updateItem = new JaxAgileItem();
        if (dialog == null) {
            return false;
        }
        if (dialog.getResult().length == 0) {
            updateItem.setRemoveFeatures(true);
        } else {
            updateItem.setSetFeatures(true);
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                updateItem.getFeatures().add(((JaxAgileFeatureGroup)object).getId());
                ++n2;
            }
        }
        for (AbstractWorkflowArtifact abstractWorkflowArtifact : awas) {
            updateItem.getIds().add(abstractWorkflowArtifact.getId());
        }
        try {
            agileEp.updateAgileItem(teamId, updateItem);
            ArtifactQuery.reloadArtifacts(awas);
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)exception);
        }
        return true;
    }

    public static FilteredCheckboxTreeDialog<JaxAgileFeatureGroup> openSelectionDialog(long teamId, Collection<? extends AbstractWorkflowArtifact> awas) {
        AtsConfigurations configurations = AtsApiService.get().getConfigService().getConfigurations();
        ArrayList<JaxAgileFeatureGroup> activeFeatureGroups = new ArrayList<JaxAgileFeatureGroup>();
        for (Map.Entry entry : configurations.getFeatureToAgileTeam().entrySet()) {
            JaxAgileFeatureGroup feature;
            Long featureId = (Long)entry.getKey();
            Long agileTeamId = (Long)entry.getValue();
            if (!agileTeamId.equals(teamId) || !(feature = (JaxAgileFeatureGroup)configurations.getIdToAgileFeature().get(featureId)).isActive()) continue;
            activeFeatureGroups.add(feature);
        }
        FilteredCheckboxTreeDialog dialog = new FilteredCheckboxTreeDialog("Select Feature Group(s)", "Select Feature Group(s)", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider(), (ViewerComparator)new StringNameComparator());
        dialog.setInput(activeFeatureGroups);
        Collection<JaxAgileFeatureGroup> selectedFeatureGroups = AgileFeatureGroupColumn.getSelectedFeatureGroups(awas);
        if (!selectedFeatureGroups.isEmpty()) {
            dialog.setInitialSelections(selectedFeatureGroups);
        }
        dialog.setShowSelectButtons(true);
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        return dialog;
    }

    private static Collection<JaxAgileFeatureGroup> getSelectedFeatureGroups(Collection<? extends AbstractWorkflowArtifact> awas) {
        LinkedList<JaxAgileFeatureGroup> selected = new LinkedList<JaxAgileFeatureGroup>();
        if (awas.size() == 1) {
            for (Artifact featureArt : awas.iterator().next().getRelatedArtifacts(AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
                IAgileFeatureGroup featureGroup = AtsApiService.get().getAgileService().getAgileFeatureGroup((ArtifactId)featureArt);
                if (!featureGroup.isActive()) continue;
                selected.add(AgileFactory.createJaxAgileFeatureGroup((IAgileFeatureGroup)featureGroup));
            }
        }
        return selected;
    }

    @Override
    public Long getKey(Object obj) {
        Long result = 0L;
        if (obj instanceof IAtsObject) {
            result = ((IAtsObject)obj).getId();
        } else if (obj instanceof ArtifactId) {
            result = ((ArtifactId)obj).getId();
        }
        return result;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        Collection workItemArts = AtsObjects.getTeamWfArtifacts(objects, (AtsApi)AtsApiService.get());
        for (ArtifactId workItemId : workItemArts) {
            try {
                HashSet<String> strs;
                Artifact workItem = AtsApiService.get().getQueryServiceIde().getArtifact(workItemId);
                List featureArts = workItem.getRelatedArtifacts(AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup);
                if (workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    strs = new HashSet<String>();
                    for (IAtsTeamWorkflow teamWf : AtsApiService.get().getWorkItemService().getTeams((Object)workItem)) {
                        for (ArtifactToken featureArt : AtsApiService.get().getQueryServiceIde().getArtifact(teamWf).getRelatedArtifacts(AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
                            strs.add(featureArt.getName());
                        }
                    }
                    preComputedValueMap.put(this.getKey(workItem), org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)", ", strs));
                    continue;
                }
                strs = new HashSet();
                for (ArtifactToken featureArt : featureArts) {
                    strs.add(featureArt.getName());
                }
                preComputedValueMap.put(this.getKey(workItem), org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)", ", strs));
            }
            catch (OseeCoreException ex) {
                preComputedValueMap.put(this.getKey(workItemId), LogUtil.getCellExceptionString((Exception)((Object)ex)));
            }
        }
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            ArrayList<Artifact> arts = new ArrayList<Artifact>();
            for (TreeItem item : treeItems) {
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (art == null || !art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) continue;
                awas.add((AbstractWorkflowArtifact)art);
                arts.add(art);
            }
            AgileFeatureGroupColumn.promptChangeFeatureGroup(awas);
            this.populateCachedValues(awas, this.preComputedValueMap);
            ((XViewer)this.getXViewer()).update(awas.toArray(), null);
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }
}

