/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.logging.Level;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionWizard;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class NewActionPage2
extends WizardPage {
    private XWidgetPage page;
    private final NewActionWizard wizard;
    private boolean debugPopulated = false;
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String DEADLINE = "Deadline";
    protected static final String VALIDATION_REQUIRED = "Validation Required";
    protected INewActionListener newActionListener;
    private final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            NewActionPage2.this.getContainer().updateButtons();
        }
    };

    public NewActionPage2(NewActionWizard wizard) {
        super("Create new ATS Action", "Create ATS Action", null);
        this.wizard = wizard;
        this.setMessage("Enter description, priority, change type and select Finish.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (this.wizard.getInitialDescription() != null && ((XText)this.getXWidget(DESCRIPTION)).get().equals("")) {
                ((XText)this.getXWidget(DESCRIPTION)).set(this.wizard.getInitialDescription());
            }
            if (this.wizard.isTestAction()) {
                this.handlePopulateWithDebugInfo();
            }
            this.wizard.createPage3IfNecessary();
            ((XText)this.getXWidget(DESCRIPTION)).getStyledText().setFocus();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    protected String getWidgetXml() {
        StringBuffer stringBuffer = new StringBuffer(800);
        stringBuffer.append("<WorkPage>");
        stringBuffer.append("<XWidget displayName=\"Description\" height=\"80\" required=\"true\" xwidgetType=\"XText\" fill=\"Vertically\" toolTip=\"" + AtsAttributeTypes.Description.getDescription() + "\"/>");
        this.appendCustomWidgetXml(stringBuffer);
        stringBuffer.append("<XWidget displayName=\"Change Type\"  storageName=\"ats.Change Type\" xwidgetType=\"XCombo(OPTIONS_FROM_ATTRIBUTE_VALIDITY)\" required=\"true\" horizontalLabel=\"true\" toolTip=\"" + AtsAttributeTypes.ChangeType.getDescription() + "\"/>");
        stringBuffer.append("<XWidget displayName=\"Priority\" storageName=\"ats.Priority\" xwidgetType=\"XCombo(OPTIONS_FROM_ATTRIBUTE_VALIDITY)\" required=\"true\" horizontalLabel=\"true\"/>");
        stringBuffer.append("<XWidget displayName=\"Deadline\" xwidgetType=\"XDate\" horizontalLabel=\"true\" toolTip=\"" + AtsAttributeTypes.NeedBy.getDescription() + "\"/>");
        stringBuffer.append("<XWidget displayName=\"Validation Required\" xwidgetType=\"XCheckBox\" fill=\"Vertically\" horizontalLabel=\"true\" labelAfter=\"true\" toolTip=\"" + AtsAttributeTypes.ValidationRequired.getDescription() + "\"/>");
        stringBuffer.append("</WorkPage>");
        return stringBuffer.toString();
    }

    protected void appendCustomWidgetXml(StringBuffer stringBuffer) {
    }

    public void createControl(Composite parent) {
        try {
            String widgetXml = this.getWidgetXml();
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout(1, false));
            comp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.page = new XWidgetPage(widgetXml, (IXWidgetOptionResolver)ATSXWidgetOptionResolver.getInstance());
            this.page.createBody(null, comp, null, this.xModListener, true);
            ((XText)this.getXWidget(DESCRIPTION)).getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        NewActionPage2.this.handlePopulateWithDebugInfo();
                    }
                }
            });
            if (this.addValidation()) {
                ((XCheckBox)this.getXWidget(VALIDATION_REQUIRED)).getLabelWidget().addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.button == 3) {
                            NewActionPage2.this.handlePopulateWithDebugInfo();
                        }
                    }
                });
            }
            this.setControl((Control)comp);
            this.setHelpContexts();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    protected boolean addValidation() {
        return true;
    }

    protected boolean hasNeedByDate() {
        return true;
    }

    private void setHelpContexts() {
        HelpUtil.setHelp((Control)this.getControl(), (HelpContext)AtsHelpContext.NEW_ACTION_PAGE_2);
    }

    private void handlePopulateWithDebugInfo() {
        if (this.debugPopulated) {
            return;
        }
        try {
            ((XText)this.getXWidget(DESCRIPTION)).set("See title");
            ((XCombo)this.getXWidget(PRIORITY)).set(this.getDefaultPriority());
            ((XCombo)this.getXWidget(CHANGE_TYPE)).set("Improvement");
            this.debugPopulated = true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    protected String getDefaultPriority() {
        return "4";
    }

    public boolean isPageComplete() {
        return this.page != null && this.page.isPageComplete().isTrue();
    }

    protected XWidget getXWidget(String displayName) {
        Conditions.checkNotNull((Object)this.page, (String)"WorkPage");
        return this.page.getLayoutData(displayName).getXWidget();
    }

    public INewActionListener getNewActionListener() {
        return this.newActionListener;
    }
}

