/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.database.init.IAddDbInitChoice;
import org.eclipse.osee.framework.database.init.IDatabaseInitConfiguration;
import org.eclipse.osee.framework.database.init.IDbInitChoiceEnum;
import org.eclipse.osee.framework.database.init.IGroupSelector;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;

public class GroupSelection
implements IGroupSelector {
    private static final GroupSelection instance = new GroupSelection();
    private final Map<String, IDatabaseInitConfiguration> initGroups = new HashMap<String, IDatabaseInitConfiguration>();
    private boolean wasInitialized = false;

    private GroupSelection() {
    }

    public static GroupSelection getInstance() {
        instance.populateDbInitChoices();
        return instance;
    }

    private synchronized void populateDbInitChoices() {
        if (!this.wasInitialized) {
            this.wasInitialized = true;
            ExtensionDefinedObjects contributions = new ExtensionDefinedObjects("org.eclipse.osee.framework.database.init.DatabaseInitializationConfiguration", "DatabaseInitializationConfiguration", "classname");
            for (IAddDbInitChoice dbInitChoice : contributions.getObjects()) {
                dbInitChoice.addDbInitChoice(this);
            }
        }
    }

    @Override
    public void addChoice(String listName, IDatabaseInitConfiguration configuration) {
        this.initGroups.put(listName, configuration);
    }

    public List<String> getChoices() {
        ArrayList<String> choices = new ArrayList<String>(this.initGroups.keySet());
        Collections.sort(choices);
        return choices;
    }

    public IDatabaseInitConfiguration getDbInitConfiguration(String choice) {
        return this.initGroups.get(choice);
    }

    @Override
    public void addChoice(IDbInitChoiceEnum choice, IDatabaseInitConfiguration configuration) {
        this.addChoice(choice.name(), configuration);
    }
}

