/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> this.getMethod(context, (String)factoryMethodName)).map(method -> ReflectionUtils.invokeMethod((Method)method, (Object)testInstance, (Object[])new Object[0])).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private Method getMethod(ExtensionContext context, String factoryMethodName) {
        if (StringUtils.isNotBlank((String)factoryMethodName)) {
            if (factoryMethodName.contains("#")) {
                return this.getMethodByFullyQualifiedName(factoryMethodName);
            }
            return this.getMethod(context.getRequiredTestClass(), factoryMethodName);
        }
        return this.getMethod(context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
    }

    private Method getMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        Preconditions.condition((boolean)StringUtils.isBlank((String)methodParameters), () -> String.format("factory method [%s] must not declare formal parameters", fullyQualifiedMethodName));
        return this.getMethod(this.loadRequiredClass(className), methodName);
    }

    private Class<?> loadRequiredClass(String className) {
        return (Class)ReflectionUtils.tryToLoadClass((String)className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        return (Method)ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[0]).orElseThrow(() -> new JUnitException(String.format("Could not find factory method [%s] in class [%s]", methodName, clazz.getName())));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray((Object)item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

