/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.sibling.base;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.cr.sibling.base.XSiblingActionBar;
import org.eclipse.osee.ats.ide.workflow.cr.sibling.base.XSiblingXViewerFactory;
import org.eclipse.osee.ats.ide.world.mini.XMiniWorldWidget;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public abstract class XSiblingWorldWidget
extends XMiniWorldWidget
implements ArtifactWidget,
IArtifactEventListener {
    protected IAtsTeamWorkflow teamWf;

    public XSiblingWorldWidget(XSiblingXViewerFactory xSiblingXViewerFactory) {
        super("Sibling Workflows", (IXViewerFactory)xSiblingXViewerFactory);
        OseeEventManager.addListener((IEventListener)this);
    }

    @Override
    public ToolBar createActionBar(Composite tableComp) {
        final XSiblingWorldWidget fWidget = this;
        tableComp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OseeEventManager.removeListener((IEventListener)fWidget);
            }
        });
        XSiblingActionBar actionBar = new XSiblingActionBar(this);
        ToolBar toolBar = actionBar.createTaskActionBar(tableComp);
        return toolBar;
    }

    @Override
    public Collection<IAtsWorkItem> getWorkItems() {
        Collection teamWfs = this.atsApi.getWorkItemService().getTeams((Object)this.teamWf.getParentAction());
        teamWfs.remove(this.teamWf);
        return Collections.castAll((Collection)teamWfs);
    }

    public Artifact getArtifact() {
        return (Artifact)this.teamWf.getStoreObject();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsTeamWorkflow) {
            this.teamWf = (IAtsTeamWorkflow)artifact;
        }
    }

    public IAtsTeamWorkflow getTeamWf() {
        return this.teamWf;
    }

    @Override
    public Pair<Integer, String> getExtraInfoString() {
        return new Pair((Object)2, (Object)"Edit (most) fields here or double-click to open.");
    }

    @Override
    public void refresh() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XSiblingWorldWidget.this.superRefresh();
            }
        });
    }

    private void superRefresh() {
        super.refresh();
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(AtsUtilClient.getAtsBranchFilter());
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        try {
            if (this.teamWf != null && Widgets.isAccessible((Widget)this.mainComp)) {
                if (artifactEvent.isHasEvent((Artifact)this.teamWf.getParentAction().getStoreObject())) {
                    this.refresh();
                    return;
                }
                for (IAtsTeamWorkflow siblingWf : this.atsApi.getActionService().getSiblingTeamWorkflows(this.teamWf)) {
                    if (artifactEvent.isHasEvent((Artifact)siblingWf.getStoreObject())) {
                        this.refresh();
                        return;
                    }
                    if (!artifactEvent.isReloaded((Artifact)siblingWf.getStoreObject())) continue;
                    this.refresh();
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }
}

