/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryCheckDialog;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class DuplicateArtifactReport
extends XNavigateItemAction {
    public DuplicateArtifactReport() {
        super("Duplicate Artifact Report", (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{AtsNavigateViewItems.ATS_UTIL});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        String newArtId = "NEW_ART_ID";
        EntryCheckDialog diag = new EntryCheckDialog(this.getName(), "Artifact Id", "Get Next Art Id (Only check this on last run when your ready\nto fix database as it will burn a real artifact id)");
        if (diag.open() == 0) {
            String entry;
            if (diag.isChecked()) {
                newArtId = String.valueOf(ConnectionHandler.getNextSequence((String)"SKYNET_ART_ID_SEQ", (boolean)true));
            }
            if (Strings.isNotNumeric((String)(entry = diag.getEntry()))) {
                AWorkbench.popup((String)"Inavlid artifact id [%s]", (String)entry);
                return;
            }
            ArtifactId id = ArtifactId.valueOf((String)entry);
            XResultData rd = AtsApiService.get().getServerEndpoints().getHealthEndpoint().dupArtReport(id, newArtId);
            String html = XResultDataUI.getReport((XResultData)rd, (String)this.getName()).getManipulatedHtml();
            html = html.replaceAll("OSEE_COMMENT=(.*?),", "OSEE_COMMENT=<b style=\"color:blue;\">$1</b>,");
            html = html.replaceAll("TIME=(.*?),", "TIME=<b style=\"color:blue;\">$1</b>,");
            html = html.replaceAll("(ACTION:.*?);", "<b style=\"color:green;\">$1</b>");
            ResultsEditor.open((String)"Report", (String)this.getName(), (String)html);
        }
    }

    public String getDescription() {
        return "Generate a report on showing/resolving duplicate artifacts with same id.  \nWithout checking box, this will just show analysis and what querys would be.";
    }
}

