/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.HoursSpentUtil;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfePromptChangeStatus;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;

public class StateHoursSpentXWidget
extends XHyperlinkLabelValueSelection {
    private final AbstractWorkflowArtifact sma;
    private final StateXWidgetPage page;
    private final boolean isCurrentState;
    private final WorkflowEditor editor;
    public static final String TOOLTIP = "Calculation: \n     State Hours Spent: amount entered by user\n     Task Hours Spent: total hours spent of all tasks related to state\n     Review Hours Spent: total hours spent of all reviews related to state\nTotal State Hours Spent: state hours + all task hours + all review hours";

    public StateHoursSpentXWidget(IManagedForm managedForm, StateXWidgetPage page, AbstractWorkflowArtifact sma, Composite composite, int horizontalSpan, XModifiedListener xModListener, boolean isCurrentState, WorkflowEditor editor) {
        super("\"" + page.getName() + "\"" + " State Hours Spent");
        this.page = page;
        this.sma = sma;
        this.isCurrentState = isCurrentState;
        this.editor = editor;
        if (xModListener != null) {
            this.addXModifiedListener(xModListener);
        }
        this.setEditable(isCurrentState && !sma.isReadOnly());
        this.setFillHorizontally(true);
        this.setToolTip(TOOLTIP);
        super.createWidgets(managedForm, composite, horizontalSpan);
    }

    public boolean handleSelection() {
        try {
            WfePromptChangeStatus.promptChangeStatus(Collections.singleton(this.sma), false);
            this.editor.onDirtied();
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public String getCurrentValue() {
        if (this.page == null) {
            return "page == null";
        }
        try {
            StringBuffer sb = new StringBuffer(String.format("        State Hours: %5.2f", this.sma.getStateMgr().getHoursSpent(this.page.getName())));
            this.setEditable(this.isCurrentState && !this.sma.isReadOnly());
            boolean breakoutNeeded = false;
            if (this.sma instanceof TeamWorkFlowArtifact && AtsApiService.get().getTaskService().hasTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)this.sma))) {
                sb.append(String.format("\n        Task  Hours: %5.2f", HoursSpentUtil.getHoursSpentFromStateTasks((IAtsObject)this.sma, (IStateToken)this.page, (AtsApi)AtsApiService.get())));
                breakoutNeeded = true;
            }
            if (this.sma.isTeamWorkflow() && AtsApiService.get().getReviewService().hasReviews((IAtsTeamWorkflow)((TeamWorkFlowArtifact)this.sma))) {
                sb.append(String.format("\n     Review Hours: %5.2f", this.getHoursSpent((TeamWorkFlowArtifact)this.sma, this.page)));
                breakoutNeeded = true;
            }
            if (breakoutNeeded) {
                this.setToolTip(sb.toString());
                return String.format("%5.2f", HoursSpentUtil.getHoursSpentStateTotal((IAtsObject)this.sma, (IStateToken)this.page, (AtsApi)AtsApiService.get()));
            }
            return String.format("%5.2f", this.sma.getStateMgr().getHoursSpent(this.page.getName()));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    private double getHoursSpent(TeamWorkFlowArtifact teamArt, IStateToken relatedToState) {
        double spent = 0.0;
        for (AbstractReviewArtifact reviewArt : ReviewManager.getReviews(teamArt, relatedToState)) {
            spent += HoursSpentUtil.getHoursSpentTotal((IAtsObject)reviewArt, (AtsApi)AtsApiService.get());
        }
        return spent;
    }
}

