/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.explorer.ArtifactExplorer;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class MoveWorkflowWorkingBranchToWorkflowAction
extends AbstractAtsAction {
    private static final String MSG = "Move Workflow Branch to This Workflow";
    private final AtsApi atsApi;
    private final ISelectedAtsArtifacts selectedAtsArtifacts;

    public MoveWorkflowWorkingBranchToWorkflowAction(ISelectedAtsArtifacts selectedAtsArtifacts, AtsApi atsApi) {
        super(MSG, ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.BRANCH_WORKING));
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.atsApi = atsApi;
        this.setToolTipText(this.getText());
    }

    @Override
    public void runWithException() {
        LinkedList<Long> associatedWfIds = new LinkedList<Long>();
        for (BranchId branch : this.atsApi.getBranchService().getBranches(BranchArchivedState.UNARCHIVED, BranchType.WORKING)) {
            ArtifactId associatedArtifactId = this.atsApi.getBranchService().getAssociatedArtifactId(branch);
            if (!associatedArtifactId.isValid()) continue;
            associatedWfIds.add(associatedArtifactId.getId());
        }
        Collection teamWfs = this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andIds(associatedWfIds.toArray(new Long[associatedWfIds.size()])).getItems();
        FilteredTreeDialog dialog = new FilteredTreeDialog(MSG, "Select Team Workflow to move branch from.", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new AtsObjectLabelProvider(false, true));
        dialog.setInput((Object)teamWfs);
        dialog.setMultiSelect(false);
        if (dialog.open() == 0) {
            IAtsTeamWorkflow fromTeamWf = (IAtsTeamWorkflow)dialog.getSelectedFirst();
            IAtsTeamWorkflow toTeamWf = (IAtsTeamWorkflow)this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().iterator().next();
            String newBranchName = this.atsApi.getBranchService().getBranchName(toTeamWf);
            String message = String.format("Are you sure you wish to move Working Branch\nfrom\n%s\nto\n%s?\n\nBranch will be renamed to:", fromTeamWf.toStringWithId(), toTeamWf.toStringWithId());
            EntryDialog dialog2 = new EntryDialog(MSG, message);
            dialog2.setEntry(newBranchName);
            if (dialog2.open() == 0) {
                newBranchName = dialog2.getEntry();
                Result result = this.atsApi.getBranchService().moveWorkingBranch(fromTeamWf, toTeamWf, newBranchName);
                if (result.isFalse()) {
                    AWorkbench.popup((String)"Move Branch Failed", (String)result.getText());
                } else {
                    ArtifactExplorer.exploreBranch((BranchId)this.atsApi.getBranchService().getWorkingBranch(toTeamWf));
                    AWorkbench.popup((String)"Completed");
                }
            }
        }
    }
}

