/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osee.framework.ui.swt.IContentProviderRunnable;
import org.eclipse.osee.framework.ui.swt.ITreeNode;

public class TreeNode
implements ITreeNode,
Serializable {
    private static final long serialVersionUID = -4932401485883022954L;
    private ITreeNode parent;
    protected Object[] children;
    private Object backingData;

    protected TreeNode() {
    }

    public TreeNode(Object backingData) {
        this(null, null, backingData);
    }

    public TreeNode(ITreeNode parent, Object[] children, Object backingData) {
        this.parent = parent;
        this.children = children;
        this.backingData = backingData;
    }

    @Override
    public Object[] getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Object[] objChildren) {
        if (objChildren == null) {
            this.children = new Object[0];
        } else {
            ArrayList<Object> newChildren = new ArrayList<Object>(objChildren.length);
            Object[] objectArray = objChildren;
            int n = objChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                newChildren.add(obj instanceof ITreeNode ? obj : this.getChild(obj));
                ++n2;
            }
            this.children = newChildren.toArray();
        }
    }

    @Override
    public Object getBackingData() {
        return this.backingData;
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    protected ITreeNode getChild(Object backingData) {
        return new TreeNode(this, null, backingData);
    }

    public static void fillNode(ITreeNode node, IContentProviderRunnable provider) {
        try {
            node.setChildren(provider.run(node.getBackingData()));
            Object[] objectArray = node.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                TreeNode.fillNode((ITreeNode)child, provider);
                ++n2;
            }
        }
        catch (Exception e) {
            node.setChildren(new Object[]{e});
        }
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("adapter can not be null");
        }
        if (this.backingData instanceof IAdaptable) {
            return (T)((IAdaptable)this.backingData).getAdapter(type);
        }
        if (type.isInstance(this.backingData)) {
            return (T)this.backingData;
        }
        if (type.isInstance(this)) {
            return (T)this;
        }
        return null;
    }
}

